/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.view;

import android.view.VelocityTracker;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.FloatAssert;

public class VelocityTrackerAssert
extends AbstractAssert<VelocityTrackerAssert, VelocityTracker> {
    public VelocityTrackerAssert(VelocityTracker actual) {
        super((Object)actual, VelocityTrackerAssert.class);
    }

    public VelocityTrackerAssert hasXVelocity(float velocity) {
        this.isNotNull();
        float actualVelocity = ((VelocityTracker)this.actual).getXVelocity();
        ((FloatAssert)Assertions.assertThat((float)actualVelocity).overridingErrorMessage("Expected X velocity <%s> but was <%s>", new Object[]{Float.valueOf(velocity), Float.valueOf(actualVelocity)})).isEqualTo(velocity);
        return this;
    }

    public VelocityTrackerAssert hasXVelocity(int id, float velocity) {
        this.isNotNull();
        float actualVelocity = ((VelocityTracker)this.actual).getXVelocity(id);
        ((FloatAssert)Assertions.assertThat((float)actualVelocity).overridingErrorMessage("Expected X velocity <%s> with ID %s but was <%s>", new Object[]{Float.valueOf(velocity), id, Float.valueOf(actualVelocity)})).isEqualTo(velocity);
        return this;
    }

    public VelocityTrackerAssert hasYVelocity(float velocity) {
        this.isNotNull();
        float actualVelocity = ((VelocityTracker)this.actual).getYVelocity();
        ((FloatAssert)Assertions.assertThat((float)actualVelocity).overridingErrorMessage("Expected Y velocity <%s> but was <%s>", new Object[]{Float.valueOf(velocity), Float.valueOf(actualVelocity)})).isEqualTo(velocity);
        return this;
    }

    public VelocityTrackerAssert hasYVelocity(int id, float velocity) {
        this.isNotNull();
        float actualVelocity = ((VelocityTracker)this.actual).getYVelocity(id);
        ((FloatAssert)Assertions.assertThat((float)actualVelocity).overridingErrorMessage("Expected Y velocity <%s> with ID %s but was <%s>", new Object[]{Float.valueOf(velocity), id, Float.valueOf(actualVelocity)})).isEqualTo(velocity);
        return this;
    }
}

