/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.view;

import android.view.KeyEvent;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.CharacterAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.LongAssert;
import org.fest.assertions.api.android.view.AbstractInputEventAssert;

public class KeyEventAssert
extends AbstractInputEventAssert<KeyEventAssert, KeyEvent> {
    public KeyEventAssert(KeyEvent actual) {
        super(actual, KeyEventAssert.class);
    }

    public KeyEventAssert hasAction(int action) {
        this.isNotNull();
        int actualAction = ((KeyEvent)this.actual).getAction();
        ((IntegerAssert)Assertions.assertThat((int)actualAction).overridingErrorMessage("Expected action <%s> but was <%s>", new Object[]{action, actualAction})).isEqualTo(action);
        return this;
    }

    public KeyEventAssert hasDisplayLabel(char label) {
        this.isNotNull();
        char actualLabel = ((KeyEvent)this.actual).getDisplayLabel();
        ((CharacterAssert)Assertions.assertThat((char)actualLabel).overridingErrorMessage("Expected label <%s> but was <%s>", new Object[]{Character.valueOf(label), Character.valueOf(actualLabel)})).isEqualTo(label);
        return this;
    }

    public KeyEventAssert hasDownTime(long time) {
        this.isNotNull();
        long actualTime = ((KeyEvent)this.actual).getDownTime();
        ((LongAssert)Assertions.assertThat((long)actualTime).overridingErrorMessage("Expected time <%s> but was <%s>", new Object[]{time, actualTime})).isEqualTo(time);
        return this;
    }

    public KeyEventAssert hasKeyCode(int keyCode) {
        this.isNotNull();
        int actualKeyCode = ((KeyEvent)this.actual).getKeyCode();
        ((IntegerAssert)Assertions.assertThat((int)actualKeyCode).overridingErrorMessage("Expected key code <%s> but was <%s>", new Object[]{keyCode, actualKeyCode})).isEqualTo(keyCode);
        return this;
    }

    public KeyEventAssert hasRepeatCount(int count) {
        this.isNotNull();
        int actualCount = ((KeyEvent)this.actual).getRepeatCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected repeat count <%s> but was <%s>", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    @Override
    public KeyEventAssert hasSource(int source) {
        this.isNotNull();
        int actualSource = ((KeyEvent)this.actual).getSource();
        ((IntegerAssert)Assertions.assertThat((int)actualSource).overridingErrorMessage("Expected source <%s> but was <%s>", new Object[]{source, actualSource})).isEqualTo(source);
        return this;
    }

    public KeyEventAssert hasModifiers(int modifiers) {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((KeyEvent)this.actual).hasModifiers(modifiers)).overridingErrorMessage("Expected modifiers <%s> but was not present", new Object[]{modifiers})).isTrue();
        return this;
    }

    public KeyEventAssert hasNoModifiers() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((KeyEvent)this.actual).hasNoModifiers()).overridingErrorMessage("Expected to have no modifiers but modifiers present", new Object[0])).isTrue();
        return this;
    }
}

