/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.view;

import android.view.DragEvent;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.FloatAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.ObjectAssert;

public class DragEventAssert
extends AbstractAssert<DragEventAssert, DragEvent> {
    public DragEventAssert(DragEvent actual) {
        super((Object)actual, DragEventAssert.class);
    }

    public DragEventAssert hasAction(int action) {
        this.isNotNull();
        int actualAction = ((DragEvent)this.actual).getAction();
        ((IntegerAssert)Assertions.assertThat((int)actualAction).overridingErrorMessage("Expected action <%s> but was <%s>", new Object[]{DragEventAssert.dragEventActionToString(action), DragEventAssert.dragEventActionToString(actualAction)})).isEqualTo(action);
        return this;
    }

    public DragEventAssert hasLocalState(Object localState) {
        this.isNotNull();
        Object actualLocalState = ((DragEvent)this.actual).getLocalState();
        ((ObjectAssert)Assertions.assertThat((Object)actualLocalState).overridingErrorMessage("Expected local state <%s> but was <%s>", new Object[]{localState, actualLocalState})).isEqualTo(localState);
        return this;
    }

    public DragEventAssert hasSuccessfulResult() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((DragEvent)this.actual).getResult()).overridingErrorMessage("Expected successful result but was unsuccessful", new Object[0])).isTrue();
        return this;
    }

    public DragEventAssert hasUnsuccessfulResult() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((DragEvent)this.actual).getResult()).overridingErrorMessage("Expected unsuccessful result but was successful", new Object[0])).isFalse();
        return this;
    }

    public DragEventAssert hasX(float x) {
        this.isNotNull();
        float actualX = ((DragEvent)this.actual).getX();
        ((FloatAssert)Assertions.assertThat((float)actualX).overridingErrorMessage("Expected X <%s> but was <%s>", new Object[]{Float.valueOf(x), Float.valueOf(actualX)})).isEqualTo(x);
        return this;
    }

    public DragEventAssert hasY(float y) {
        this.isNotNull();
        float actualY = ((DragEvent)this.actual).getY();
        ((FloatAssert)Assertions.assertThat((float)actualY).overridingErrorMessage("Expected Y <%s> but was <%s>", new Object[]{Float.valueOf(y), Float.valueOf(actualY)})).isEqualTo(y);
        return this;
    }

    private static String dragEventActionToString(int action) {
        switch (action) {
            case 4: {
                return "drag ended";
            }
            case 5: {
                return "drag entered";
            }
            case 6: {
                return "drag exited";
            }
            case 2: {
                return "drag location";
            }
            case 1: {
                return "drag started";
            }
            case 3: {
                return "drop";
            }
        }
        throw new IllegalArgumentException("Unknown drag event action: " + action);
    }
}

