/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.view;

import android.view.ActionMode;
import android.view.View;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.ObjectAssert;

public class ActionModeAssert
extends AbstractAssert<ActionModeAssert, ActionMode> {
    public ActionModeAssert(ActionMode actual) {
        super((Object)actual, ActionModeAssert.class);
    }

    public ActionModeAssert hasCustomView() {
        this.isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)((ActionMode)this.actual).getCustomView()).overridingErrorMessage("Expected custom view but was not present.", new Object[0])).isNotNull();
        return this;
    }

    public ActionModeAssert hasCustomView(View view) {
        this.isNotNull();
        View actualView = ((ActionMode)this.actual).getCustomView();
        ((ObjectAssert)Assertions.assertThat((Object)actualView).overridingErrorMessage("Expected custom view <%s> but was <%s>.", new Object[]{view, actualView})).isEqualTo((Object)view);
        return this;
    }

    public ActionModeAssert hasSubtitle(CharSequence subtitle) {
        this.isNotNull();
        CharSequence actualSubtitle = ((ActionMode)this.actual).getSubtitle();
        ((ObjectAssert)Assertions.assertThat((Object)actualSubtitle).overridingErrorMessage("Expected subtitle <%s> but was <%s>.", new Object[]{subtitle, actualSubtitle})).isEqualTo((Object)subtitle);
        return this;
    }

    public ActionModeAssert hasTag(Object tag) {
        this.isNotNull();
        Object actualTag = ((ActionMode)this.actual).getTag();
        ((ObjectAssert)Assertions.assertThat((Object)actualTag).overridingErrorMessage("Expected tag <%s> but was <%s>.", new Object[]{tag, actualTag})).isEqualTo(tag);
        return this;
    }

    public ActionModeAssert hasTitle(CharSequence title) {
        this.isNotNull();
        CharSequence actualTitle = ((ActionMode)this.actual).getTitle();
        ((ObjectAssert)Assertions.assertThat((Object)actualTitle).overridingErrorMessage("Expected title <%s> but was <%s>.", new Object[]{title, actualTitle})).isEqualTo((Object)title);
        return this;
    }

    public ActionModeAssert hasOptionalTitleHint() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((ActionMode)this.actual).getTitleOptionalHint()).overridingErrorMessage("Expected to have optional title hint but was not optional.", new Object[0])).isTrue();
        return this;
    }

    public ActionModeAssert hasNonOptionalTitleHint() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((ActionMode)this.actual).getTitleOptionalHint()).overridingErrorMessage("Expected to have non-optional title hint but was optional.", new Object[0])).isFalse();
        return this;
    }

    public ActionModeAssert hasOptionalTitle() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((ActionMode)this.actual).isTitleOptional()).overridingErrorMessage("Expected to have optional title but was not optional.", new Object[0])).isTrue();
        return this;
    }

    public ActionModeAssert hasNonOptionalTitle() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((ActionMode)this.actual).isTitleOptional()).overridingErrorMessage("Expected to have non-optional title but was optional.", new Object[0])).isFalse();
        return this;
    }
}

