/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.util;

import android.util.AttributeSet;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.StringAssert;

public class AttributeSetAssert
extends AbstractAssert<AttributeSetAssert, AttributeSet> {
    public AttributeSetAssert(AttributeSet actual) {
        super((Object)actual, AttributeSetAssert.class);
    }

    public AttributeSetAssert hasAttributeCount(int count) {
        this.isNotNull();
        int actualCount = ((AttributeSet)this.actual).getAttributeCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected attribute count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public AttributeSetAssert hasClassAttribute(String value) {
        this.isNotNull();
        String actualValue = ((AttributeSet)this.actual).getClassAttribute();
        ((StringAssert)Assertions.assertThat((String)actualValue).overridingErrorMessage("Expected class attribute value <%s> but was <%s>.", new Object[]{value, actualValue})).isEqualTo((Object)value);
        return this;
    }

    public AttributeSetAssert hasIdAttribute(String value) {
        this.isNotNull();
        String actualValue = ((AttributeSet)this.actual).getIdAttribute();
        ((StringAssert)Assertions.assertThat((String)actualValue).overridingErrorMessage("Exepcted ID attribute value <%s> but was <%s>.", new Object[]{value, actualValue})).isEqualTo((Object)value);
        return this;
    }

    public AttributeSetAssert hasPositionDescription(String position) {
        this.isNotNull();
        String actualPosition = ((AttributeSet)this.actual).getPositionDescription();
        ((StringAssert)Assertions.assertThat((String)actualPosition).overridingErrorMessage("Expected position description <%s> but was <%s>.", new Object[]{position, actualPosition})).isEqualTo((Object)position);
        return this;
    }

    public AttributeSetAssert hasStyleAttribute(int value) {
        this.isNotNull();
        int actualValue = ((AttributeSet)this.actual).getStyleAttribute();
        ((IntegerAssert)Assertions.assertThat((int)actualValue).overridingErrorMessage("Expected style attribute value <%s> but was <%s>.", new Object[]{value, actualValue})).isEqualTo(value);
        return this;
    }
}

