/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.preference;

import android.preference.TwoStatePreference;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.ObjectAssert;
import org.fest.assertions.api.android.preference.AbstractPreferenceAssert;

public abstract class AbstractTwoStatePreference<S extends AbstractTwoStatePreference<S, A>, A extends TwoStatePreference>
extends AbstractPreferenceAssert<S, A> {
    protected AbstractTwoStatePreference(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasSummaryOff(CharSequence summary) {
        this.isNotNull();
        CharSequence actualSummary = ((TwoStatePreference)this.actual).getSummaryOff();
        ((ObjectAssert)Assertions.assertThat((Object)actualSummary).overridingErrorMessage("Expected off summary <%s> but was <%s>.", new Object[]{summary, actualSummary})).isEqualTo((Object)summary);
        return (S)((Object)((AbstractTwoStatePreference)this.myself));
    }

    public S hasSummaryOff(int resId) {
        this.isNotNull();
        return this.hasSummaryOff(((TwoStatePreference)this.actual).getContext().getString(resId));
    }

    public S hasSummaryOn(CharSequence summary) {
        this.isNotNull();
        CharSequence actualSummary = ((TwoStatePreference)this.actual).getSummaryOn();
        ((ObjectAssert)Assertions.assertThat((Object)actualSummary).overridingErrorMessage("Expected on summary <%s> but was <%s>.", new Object[]{summary, actualSummary})).isEqualTo((Object)summary);
        return (S)((Object)((AbstractTwoStatePreference)this.myself));
    }

    public S hasSummaryOn(int resId) {
        this.isNotNull();
        return this.hasSummaryOn(((TwoStatePreference)this.actual).getContext().getString(resId));
    }

    public S isChecked() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((TwoStatePreference)this.actual).isChecked()).overridingErrorMessage("Expected to be checked but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractTwoStatePreference)this.myself));
    }

    public S isNotChecked() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((TwoStatePreference)this.actual).isChecked()).overridingErrorMessage("Expected to not be checked but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractTwoStatePreference)this.myself));
    }
}

