/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.location;

import android.location.Criteria;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.IntegerAssert;

public class CriteriaAssert
extends AbstractAssert<CriteriaAssert, Criteria> {
    public CriteriaAssert(Criteria actual) {
        super((Object)actual, CriteriaAssert.class);
    }

    public CriteriaAssert hasAccuracy(int accuracy) {
        this.isNotNull();
        int actualAccuracy = ((Criteria)this.actual).getAccuracy();
        ((IntegerAssert)Assertions.assertThat((int)actualAccuracy).overridingErrorMessage("Expected accuracy <%s> but was <%s>.", new Object[]{CriteriaAssert.accuracyRequirementToString(accuracy), CriteriaAssert.accuracyRequirementToString(actualAccuracy)})).isEqualTo(accuracy);
        return this;
    }

    public CriteriaAssert hasBearingAccuracy(int accuracy) {
        this.isNotNull();
        int actualAccuracy = ((Criteria)this.actual).getBearingAccuracy();
        ((IntegerAssert)Assertions.assertThat((int)actualAccuracy).overridingErrorMessage("Expected bearing accuracy <%s> but was <%s>.", new Object[]{CriteriaAssert.accuracyToString(accuracy), CriteriaAssert.accuracyToString(actualAccuracy)})).isEqualTo(accuracy);
        return this;
    }

    public CriteriaAssert hasHorizontalAccuracy(int accuracy) {
        this.isNotNull();
        int actualAccuracy = ((Criteria)this.actual).getHorizontalAccuracy();
        ((IntegerAssert)Assertions.assertThat((int)actualAccuracy).overridingErrorMessage("Expected horizontal accuracy <%s> but was <%s>.", new Object[]{CriteriaAssert.accuracyToString(accuracy), CriteriaAssert.accuracyToString(actualAccuracy)})).isEqualTo(accuracy);
        return this;
    }

    public CriteriaAssert hasPowerRequirement(int requirement) {
        this.isNotNull();
        int actualRequirement = ((Criteria)this.actual).getPowerRequirement();
        ((IntegerAssert)Assertions.assertThat((int)actualRequirement).overridingErrorMessage("Expected power requirement <%s> but was <%s>.", new Object[]{CriteriaAssert.powerRequirementToString(requirement), CriteriaAssert.powerRequirementToString(actualRequirement)})).isEqualTo(requirement);
        return this;
    }

    public CriteriaAssert hasSpeedAccuracy(int accuracy) {
        this.isNotNull();
        int actualAccuracy = ((Criteria)this.actual).getSpeedAccuracy();
        ((IntegerAssert)Assertions.assertThat((int)actualAccuracy).overridingErrorMessage("Expected speed accuracy <%s> but was <%s>.", new Object[]{CriteriaAssert.accuracyToString(accuracy), CriteriaAssert.accuracyToString(actualAccuracy)})).isEqualTo(accuracy);
        return this;
    }

    public CriteriaAssert hasVerticalAccuracy(int accuracy) {
        this.isNotNull();
        int actualAccuracy = ((Criteria)this.actual).getVerticalAccuracy();
        ((IntegerAssert)Assertions.assertThat((int)actualAccuracy).overridingErrorMessage("Expected vertical accuracy <%s> but was <%s>.", new Object[]{CriteriaAssert.accuracyToString(accuracy), CriteriaAssert.accuracyToString(actualAccuracy)})).isEqualTo(accuracy);
        return this;
    }

    public CriteriaAssert isAltitudeRequired() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Criteria)this.actual).isAltitudeRequired()).overridingErrorMessage("Expected altitude to be required but was not.", new Object[0])).isTrue();
        return this;
    }

    public CriteriaAssert isAltitudeNotRequired() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Criteria)this.actual).isAltitudeRequired()).overridingErrorMessage("Expected altitude to not be required but was.", new Object[0])).isFalse();
        return this;
    }

    public CriteriaAssert isBearingRequired() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Criteria)this.actual).isBearingRequired()).overridingErrorMessage("Expected bearing to be required but was not.", new Object[0])).isTrue();
        return this;
    }

    public CriteriaAssert isBearingNotRequired() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Criteria)this.actual).isBearingRequired()).overridingErrorMessage("Expected bearing to not be required but was.", new Object[0])).isFalse();
        return this;
    }

    public CriteriaAssert isCostAllowed() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Criteria)this.actual).isCostAllowed()).overridingErrorMessage("Expected cost to be allowed but was not.", new Object[0])).isTrue();
        return this;
    }

    public CriteriaAssert isCostNotAllowed() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Criteria)this.actual).isCostAllowed()).overridingErrorMessage("Expected cost to not be allowed but was.", new Object[0])).isFalse();
        return this;
    }

    public CriteriaAssert isSpeedRequired() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Criteria)this.actual).isSpeedRequired()).overridingErrorMessage("Expected speed to be required but was not.", new Object[0])).isTrue();
        return this;
    }

    public CriteriaAssert isSpeedNotRequired() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Criteria)this.actual).isSpeedRequired()).overridingErrorMessage("Expected speed to not be required but was.", new Object[0])).isFalse();
        return this;
    }

    static String accuracyRequirementToString(int accuracy) {
        switch (accuracy) {
            case 2: {
                return "coarse";
            }
            case 1: {
                return "fine";
            }
        }
        throw new IllegalArgumentException("Unknown accuracy requirement: " + accuracy);
    }

    private static String accuracyToString(int accuracy) {
        switch (accuracy) {
            case 3: {
                return "high";
            }
            case 2: {
                return "medium";
            }
            case 1: {
                return "low";
            }
        }
        throw new IllegalArgumentException("Unknown accuracy: " + accuracy);
    }

    static String powerRequirementToString(int requirement) {
        switch (requirement) {
            case 0: {
                return "none";
            }
            case 1: {
                return "low";
            }
            case 2: {
                return "medium";
            }
            case 3: {
                return "high";
            }
        }
        throw new IllegalArgumentException("Unknown power requirement: " + requirement);
    }
}

