/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.hardware.usb;

import android.hardware.usb.UsbEndpoint;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.IntegerAssert;

public class UsbEndpointAssert
extends AbstractAssert<UsbEndpointAssert, UsbEndpoint> {
    public UsbEndpointAssert(UsbEndpoint actual) {
        super((Object)actual, UsbEndpointAssert.class);
    }

    public UsbEndpointAssert hasAddress(int address) {
        this.isNotNull();
        int actualAddress = ((UsbEndpoint)this.actual).getAddress();
        ((IntegerAssert)Assertions.assertThat((int)actualAddress).overridingErrorMessage("Expected address <%s> but was <%s>.", new Object[]{address, actualAddress})).isEqualTo(address);
        return this;
    }

    public UsbEndpointAssert hasAttributes(int attributes) {
        this.isNotNull();
        int actualAttributes = ((UsbEndpoint)this.actual).getAttributes();
        ((IntegerAssert)Assertions.assertThat((int)actualAttributes).overridingErrorMessage("Expected attributes <%s> but was <%s>.", new Object[]{attributes, actualAttributes})).isEqualTo(attributes);
        return this;
    }

    public UsbEndpointAssert hasDirection(int direction) {
        this.isNotNull();
        int actualDirection = ((UsbEndpoint)this.actual).getDirection();
        ((IntegerAssert)Assertions.assertThat((int)actualDirection).overridingErrorMessage("Expected direction <%s> but was <%s>.", new Object[]{direction, actualDirection})).isEqualTo(direction);
        return this;
    }

    public UsbEndpointAssert hasEndpointNumber(int number) {
        this.isNotNull();
        int actualNumber = ((UsbEndpoint)this.actual).getEndpointNumber();
        ((IntegerAssert)Assertions.assertThat((int)actualNumber).overridingErrorMessage("Expected endpoint number <%s> but was <%s>.", new Object[]{number, actualNumber})).isEqualTo(number);
        return this;
    }

    public UsbEndpointAssert hasInterval(int interval) {
        this.isNotNull();
        int actualInterval = ((UsbEndpoint)this.actual).getInterval();
        ((IntegerAssert)Assertions.assertThat((int)actualInterval).overridingErrorMessage("Expected interval <%s> but was <%s>.", new Object[]{interval, actualInterval})).isEqualTo(interval);
        return this;
    }

    public UsbEndpointAssert hasMaximumPacketSize(int size) {
        this.isNotNull();
        int actualSize = ((UsbEndpoint)this.actual).getMaxPacketSize();
        ((IntegerAssert)Assertions.assertThat((int)actualSize).overridingErrorMessage("Expected maximum packet size <%s> but was <%s>.", new Object[]{size, actualSize})).isEqualTo(size);
        return this;
    }

    public UsbEndpointAssert hasType(int type) {
        this.isNotNull();
        int actualType = ((UsbEndpoint)this.actual).getType();
        ((IntegerAssert)Assertions.assertThat((int)actualType).overridingErrorMessage("Expected type <%s> but was <%s>.", new Object[]{type, actualType})).isEqualTo(type);
        return this;
    }
}

