/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.hardware.usb;

import android.hardware.usb.UsbDeviceConnection;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.ByteArrayAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.StringAssert;

public class UsbDeviceConnectionAssert
extends AbstractAssert<UsbDeviceConnectionAssert, UsbDeviceConnection> {
    public UsbDeviceConnectionAssert(UsbDeviceConnection actual) {
        super((Object)actual, UsbDeviceConnectionAssert.class);
    }

    public UsbDeviceConnectionAssert hasFileDescriptor(int descriptor) {
        this.isNotNull();
        int actualDescriptor = ((UsbDeviceConnection)this.actual).getFileDescriptor();
        ((IntegerAssert)Assertions.assertThat((int)actualDescriptor).overridingErrorMessage("Expected file descriptor <%s> but was <%s>.", new Object[]{descriptor, actualDescriptor})).isEqualTo(descriptor);
        return this;
    }

    public UsbDeviceConnectionAssert hasRawDescriptors(byte[] descriptors) {
        this.isNotNull();
        byte[] actualDescriptors = ((UsbDeviceConnection)this.actual).getRawDescriptors();
        ((ByteArrayAssert)Assertions.assertThat((byte[])actualDescriptors).overridingErrorMessage("Expected raw descriptors <%s> but was <%s>.", new Object[]{descriptors, actualDescriptors})).isEqualTo((Object)descriptors);
        return this;
    }

    public UsbDeviceConnectionAssert hasSerial(String serial) {
        this.isNotNull();
        String actualSerial = ((UsbDeviceConnection)this.actual).getSerial();
        ((StringAssert)Assertions.assertThat((String)actualSerial).overridingErrorMessage("Expected serial <%s> but was <%s>.", new Object[]{serial, actualSerial})).isEqualTo((Object)serial);
        return this;
    }
}

