/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.graphics.drawable;

import android.graphics.drawable.ColorDrawable;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.android.graphics.drawable.AbstractDrawableAssert;

public class ColorDrawableAssert
extends AbstractDrawableAssert<ColorDrawableAssert, ColorDrawable> {
    public ColorDrawableAssert(ColorDrawable actual) {
        super(actual, ColorDrawableAssert.class);
    }

    public ColorDrawableAssert hasAlpha(int alpha) {
        this.isNotNull();
        int actualAlpha = ((ColorDrawable)this.actual).getAlpha();
        ((IntegerAssert)Assertions.assertThat((int)actualAlpha).overridingErrorMessage("Expected alpha <%s> but was <%s>.", new Object[]{alpha, actualAlpha})).isEqualTo(alpha);
        return this;
    }

    public ColorDrawableAssert hasColor(int color) {
        this.isNotNull();
        int actualColor = ((ColorDrawable)this.actual).getColor();
        ((IntegerAssert)Assertions.assertThat((int)actualColor).overridingErrorMessage("Expected color <%s> but was <%s>.", new Object[]{Integer.toHexString(color), Integer.toHexString(actualColor)})).isEqualTo(color);
        return this;
    }
}

