/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.graphics;

import android.graphics.Movie;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.IntegerAssert;

public class MovieAssert
extends AbstractAssert<MovieAssert, Movie> {
    public MovieAssert(Movie actual) {
        super((Object)actual, MovieAssert.class);
    }

    public MovieAssert hasDuration(int duration) {
        this.isNotNull();
        int actualDuration = ((Movie)this.actual).duration();
        ((IntegerAssert)Assertions.assertThat((int)actualDuration).overridingErrorMessage("Expected duration <%s> but was <%s>.", new Object[]{duration, actualDuration})).isEqualTo(duration);
        return this;
    }

    public MovieAssert hasHeight(int height) {
        this.isNotNull();
        int actualHeight = ((Movie)this.actual).height();
        ((IntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected height <%s> but was <%s>.", new Object[]{height, actualHeight})).isEqualTo(height);
        return this;
    }

    public MovieAssert isOpaque() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Movie)this.actual).isOpaque()).overridingErrorMessage("Expected to be opaque but was not.", new Object[0])).isTrue();
        return this;
    }

    public MovieAssert isNotOpaque() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Movie)this.actual).isOpaque()).overridingErrorMessage("Expected to not be opaque but was.", new Object[0])).isFalse();
        return this;
    }

    public MovieAssert hasWidth(int width) {
        this.isNotNull();
        int actualHeight = ((Movie)this.actual).width();
        ((IntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected width <%s> but was <%s>.", new Object[]{width, actualHeight})).isEqualTo(width);
        return this;
    }
}

