/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.animation;

import android.animation.ValueAnimator;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.FloatAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.LongAssert;
import org.fest.assertions.api.ObjectAssert;
import org.fest.assertions.api.android.animation.AbstractAnimatorAssert;

public abstract class AbstractValueAnimatorAssert<S extends AbstractValueAnimatorAssert<S, A>, A extends ValueAnimator>
extends AbstractAnimatorAssert<S, A> {
    protected AbstractValueAnimatorAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasAnimatedFraction(float fraction) {
        this.isNotNull();
        float actualFraction = ((ValueAnimator)this.actual).getAnimatedFraction();
        ((FloatAssert)Assertions.assertThat((float)actualFraction).overridingErrorMessage("Expected animated fraction <%s> but was <%s>.", new Object[]{Float.valueOf(fraction), Float.valueOf(actualFraction)})).isEqualTo(fraction);
        return (S)((Object)((AbstractValueAnimatorAssert)this.myself));
    }

    public S hasAnimatedValue(Object value) {
        this.isNotNull();
        Object actualValue = ((ValueAnimator)this.actual).getAnimatedValue();
        ((ObjectAssert)Assertions.assertThat((Object)actualValue).overridingErrorMessage("Expected animated value <%s> but was <%s>.", new Object[]{value, actualValue})).isEqualTo(value);
        return (S)((Object)((AbstractValueAnimatorAssert)this.myself));
    }

    public S hasCurrentPlayTime(long time) {
        this.isNotNull();
        long actualTime = ((ValueAnimator)this.actual).getCurrentPlayTime();
        ((LongAssert)Assertions.assertThat((long)actualTime).overridingErrorMessage("Expected current play time <%s> but was <%s>.", new Object[]{time, actualTime})).isEqualTo(time);
        return (S)((Object)((AbstractValueAnimatorAssert)this.myself));
    }

    public S hasRepeatCount(int count) {
        this.isNotNull();
        int actualCount = ((ValueAnimator)this.actual).getRepeatCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected repeat count <%s> but was <%s>.", new Object[]{AbstractValueAnimatorAssert.repeatCountToString(count), AbstractValueAnimatorAssert.repeatCountToString(actualCount)})).isEqualTo(count);
        return (S)((Object)((AbstractValueAnimatorAssert)this.myself));
    }

    public S hasRepeatMode(int mode) {
        this.isNotNull();
        int actualMode = ((ValueAnimator)this.actual).getRepeatMode();
        ((IntegerAssert)Assertions.assertThat((int)actualMode).overridingErrorMessage("Expected repeat mode <%s> but was <%s>.", new Object[]{AbstractValueAnimatorAssert.repeatModeToString(mode), AbstractValueAnimatorAssert.repeatModeToString(actualMode)})).isEqualTo(mode);
        return (S)((Object)((AbstractValueAnimatorAssert)this.myself));
    }

    private static String repeatCountToString(int count) {
        if (count == -1) {
            return "infinite";
        }
        return Integer.toString(count);
    }

    private static String repeatModeToString(int mode) {
        switch (mode) {
            case 1: {
                return "restart";
            }
            case 2: {
                return "reverse";
            }
        }
        throw new IllegalArgumentException("Unknown repeat mode: " + mode);
    }
}

