/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.duktape;

import java.io.Closeable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashMap;
import java.util.logging.Logger;

public final class Duktape
implements Closeable {
    private long context;

    public static Duktape create() {
        long context = Duktape.createContext();
        if (context == 0L) {
            throw new OutOfMemoryError("Cannot create Duktape instance");
        }
        return new Duktape(context);
    }

    private Duktape(long context) {
        this.context = context;
    }

    public synchronized Object evaluate(String script, String fileName) {
        return Duktape.evaluate(this.context, script, fileName);
    }

    public synchronized Object evaluate(String script) {
        return Duktape.evaluate(this.context, script, "?");
    }

    public synchronized <T> void set(String name, Class<T> type, T object) {
        if (!type.isInterface()) {
            throw new UnsupportedOperationException("Only interfaces can be bound. Received: " + type);
        }
        if (type.getInterfaces().length > 0) {
            throw new UnsupportedOperationException(type + " must not extend other interfaces");
        }
        if (!type.isInstance(object)) {
            throw new IllegalArgumentException(object.getClass() + " is not an instance of " + type);
        }
        LinkedHashMap<String, Method> methods = new LinkedHashMap<String, Method>();
        for (Method method : type.getMethods()) {
            if (methods.put(method.getName(), method) == null) continue;
            throw new UnsupportedOperationException(method.getName() + " is overloaded in " + type);
        }
        Duktape.set(this.context, name, object, methods.values().toArray());
    }

    public synchronized <T> T get(final String name, final Class<T> type) {
        if (!type.isInterface()) {
            throw new UnsupportedOperationException("Only interfaces can be proxied. Received: " + type);
        }
        if (type.getInterfaces().length > 0) {
            throw new UnsupportedOperationException(type + " must not extend other interfaces");
        }
        LinkedHashMap<String, Method> methods = new LinkedHashMap<String, Method>();
        for (Method method : type.getMethods()) {
            if (methods.put(method.getName(), method) == null) continue;
            throw new UnsupportedOperationException(method.getName() + " is overloaded in " + type);
        }
        final long instance = Duktape.get(this.context, name, methods.values().toArray());
        final Duktape duktape = this;
        Object proxy = Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, new InvocationHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass() == Object.class) {
                    return method.invoke((Object)this, args);
                }
                Duktape duktape2 = duktape;
                synchronized (duktape2) {
                    return Duktape.call(duktape.context, instance, method, args);
                }
            }

            public String toString() {
                return String.format("DuktapeProxy{name=%s, type=%s}", name, type.getName());
            }
        });
        return (T)proxy;
    }

    @Override
    public synchronized void close() {
        if (this.context != 0L) {
            long contextToClose = this.context;
            this.context = 0L;
            Duktape.destroyContext(contextToClose);
        }
    }

    protected synchronized void finalize() throws Throwable {
        if (this.context != 0L) {
            Logger.getLogger(this.getClass().getName()).warning("Duktape instance leaked!");
        }
    }

    private static native long createContext();

    private static native void destroyContext(long var0);

    private static native Object evaluate(long var0, String var2, String var3);

    private static native void set(long var0, String var2, Object var3, Object[] var4);

    private static native long get(long var0, String var2, Object[] var3);

    private static native Object call(long var0, long var2, Object var4, Object[] var5);

    static {
        System.loadLibrary("duktape");
    }
}

