/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.widget;

import android.annotation.TargetApi;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ListPopupWindow;
import android.widget.ListView;
import org.assertj.android.internal.IntegerUtils;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

@TargetApi(value=11)
public class ListPopupWindowAssert
extends AbstractAssert<ListPopupWindowAssert, ListPopupWindow> {
    public ListPopupWindowAssert(ListPopupWindow actual) {
        super((Object)actual, ListPopupWindowAssert.class);
    }

    public ListPopupWindowAssert hasAnchorView(View view) {
        this.isNotNull();
        View actualView = ((ListPopupWindow)this.actual).getAnchorView();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualView).overridingErrorMessage("Expected anchor view <%s> but was <%s>.", new Object[]{view, actualView})).isSameAs((Object)view);
        return this;
    }

    public ListPopupWindowAssert hasAnimationStyle(int style) {
        this.isNotNull();
        int actualStyle = ((ListPopupWindow)this.actual).getAnimationStyle();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualStyle).overridingErrorMessage("Expected animation style <%s> but was <%s>.", new Object[]{style, actualStyle})).isEqualTo(style);
        return this;
    }

    public ListPopupWindowAssert hasBackground(Drawable background) {
        this.isNotNull();
        Drawable actualBackground = ((ListPopupWindow)this.actual).getBackground();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualBackground).overridingErrorMessage("Expected background <%s> but was <%s>.", new Object[]{background, actualBackground})).isSameAs((Object)background);
        return this;
    }

    public ListPopupWindowAssert hasHeight(int height) {
        this.isNotNull();
        int actualHeight = ((ListPopupWindow)this.actual).getHeight();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected height <%s> but was <%s>.", new Object[]{height, actualHeight})).isEqualTo(height);
        return this;
    }

    public ListPopupWindowAssert hasHorizontalOffset(int offset) {
        this.isNotNull();
        int actualOffset = ((ListPopupWindow)this.actual).getHorizontalOffset();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualOffset).overridingErrorMessage("Expected horizontal offset <%s> but was <%s>.", new Object[]{offset, actualOffset})).isEqualTo(offset);
        return this;
    }

    public ListPopupWindowAssert hasInputMethodMode(int mode) {
        this.isNotNull();
        int actualMode = ((ListPopupWindow)this.actual).getInputMethodMode();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualMode).overridingErrorMessage("Expected input method mode <%s> but was <%s>.", new Object[]{ListPopupWindowAssert.inputMethodModeToString(mode), ListPopupWindowAssert.inputMethodModeToString(actualMode)})).isEqualTo(mode);
        return this;
    }

    public ListPopupWindowAssert hasListView(ListView view) {
        this.isNotNull();
        ListView actualView = ((ListPopupWindow)this.actual).getListView();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualView).overridingErrorMessage("Expected ListView <%s> but was <%s>.", new Object[]{view, actualView})).isSameAs((Object)view);
        return this;
    }

    public ListPopupWindowAssert hasPromptPosition(int position) {
        this.isNotNull();
        int actualPosition = ((ListPopupWindow)this.actual).getPromptPosition();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPosition).overridingErrorMessage("Expected prompt position <%s> but was <%s>.", new Object[]{position, actualPosition})).isEqualTo(position);
        return this;
    }

    public ListPopupWindowAssert hasSelectedItem(Object item) {
        this.isNotNull();
        Object actualItem = ((ListPopupWindow)this.actual).getSelectedItem();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualItem).overridingErrorMessage("Expected selected item <%s> but was <%s>.", new Object[]{item, actualItem})).isEqualTo(item);
        return this;
    }

    public ListPopupWindowAssert hasSelectedItemId(long id) {
        this.isNotNull();
        long actualId = ((ListPopupWindow)this.actual).getSelectedItemId();
        ((AbstractLongAssert)Assertions.assertThat((long)actualId).overridingErrorMessage("Expected selected item ID <%s> but was <%s>.", new Object[]{id, actualId})).isEqualTo(id);
        return this;
    }

    public ListPopupWindowAssert hasSelectedItemPosition(int position) {
        this.isNotNull();
        int actualPosition = ((ListPopupWindow)this.actual).getSelectedItemPosition();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPosition).overridingErrorMessage("Expected selected item position <%s> but was <%s>.", new Object[]{position, actualPosition})).isEqualTo(position);
        return this;
    }

    public ListPopupWindowAssert hasSelectedItemView(View view) {
        this.isNotNull();
        View actualView = ((ListPopupWindow)this.actual).getSelectedView();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualView).overridingErrorMessage("Expected selected item view <%s> but was <%s>.", new Object[]{view, actualView})).isSameAs((Object)view);
        return this;
    }

    public ListPopupWindowAssert hasSoftInputMode(int mode) {
        this.isNotNull();
        int actualMode = ((ListPopupWindow)this.actual).getSoftInputMode();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualMode).overridingErrorMessage("Expected soft input mode <%s> but was <%s>.", new Object[]{mode, actualMode})).isEqualTo(mode);
        return this;
    }

    public ListPopupWindowAssert hasVerticalOffset(int offset) {
        this.isNotNull();
        int actualOffset = ((ListPopupWindow)this.actual).getVerticalOffset();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualOffset).overridingErrorMessage("Expected vertical offset <%s> but was <%s>.", new Object[]{offset, actualOffset})).isEqualTo(offset);
        return this;
    }

    public ListPopupWindowAssert hasWidth(int width) {
        this.isNotNull();
        int actualWidth = ((ListPopupWindow)this.actual).getWidth();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected width <%s> but was <%s>.", new Object[]{width, actualWidth})).isEqualTo(width);
        return this;
    }

    public ListPopupWindowAssert isModal() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ListPopupWindow)this.actual).isModal()).overridingErrorMessage("Expected to be modal but was not.", new Object[0])).isTrue();
        return this;
    }

    public ListPopupWindowAssert isNotModal() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ListPopupWindow)this.actual).isModal()).overridingErrorMessage("Expected to not be modal but was.", new Object[0])).isFalse();
        return this;
    }

    public ListPopupWindowAssert isShowing() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ListPopupWindow)this.actual).isShowing()).overridingErrorMessage("Expected to be showing but was not.", new Object[0])).isTrue();
        return this;
    }

    public ListPopupWindowAssert isNotShowing() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ListPopupWindow)this.actual).isShowing()).overridingErrorMessage("Expected to not be showing but was.", new Object[0])).isFalse();
        return this;
    }

    public static String inputMethodModeToString(int mode) {
        return IntegerUtils.buildNamedValueString(mode).value(0, "fromFocusable").value(1, "needed").value(2, "notNeeded").get();
    }
}

