/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.widget;

import android.annotation.TargetApi;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import org.assertj.android.api.view.AbstractViewAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

public class ImageViewAssert
extends AbstractViewAssert<ImageViewAssert, ImageView> {
    public ImageViewAssert(ImageView actual) {
        super(actual, ImageViewAssert.class);
    }

    @TargetApi(value=11)
    public ImageViewAssert isAligningBaselineToBottom() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ImageView)this.actual).getBaselineAlignBottom()).overridingErrorMessage("Expected to be aligning baseline to bottom but was not.", new Object[0])).isTrue();
        return this;
    }

    @TargetApi(value=11)
    public ImageViewAssert isNotAligningBaselineToBottom() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ImageView)this.actual).getBaselineAlignBottom()).overridingErrorMessage("Expected to not be aligning baseline to bottom but was.", new Object[0])).isFalse();
        return this;
    }

    @TargetApi(value=16)
    public ImageViewAssert isCroppingToPadding() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ImageView)this.actual).getCropToPadding()).overridingErrorMessage("Expected to be cropping to padding but was not.", new Object[0])).isTrue();
        return this;
    }

    @TargetApi(value=16)
    public ImageViewAssert isNotCroppingToPadding() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ImageView)this.actual).getCropToPadding()).overridingErrorMessage("Expected to not be cropping to padding but was.", new Object[0])).isFalse();
        return this;
    }

    public ImageViewAssert hasDrawable(Drawable drawable) {
        this.isNotNull();
        Drawable actualDrawable = ((ImageView)this.actual).getDrawable();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualDrawable).overridingErrorMessage("Expected drawable <%s> but was <%s>.", new Object[]{drawable, actualDrawable})).isSameAs((Object)drawable);
        return this;
    }

    @TargetApi(value=16)
    public ImageViewAssert hasImageAlpha(int alpha) {
        this.isNotNull();
        int actualAlpha = ((ImageView)this.actual).getImageAlpha();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualAlpha).overridingErrorMessage("Expected image alpha <%s> but was <%s>.", new Object[]{alpha, actualAlpha})).isEqualTo(alpha);
        return this;
    }

    public ImageViewAssert hasScaleType(ImageView.ScaleType type) {
        this.isNotNull();
        ImageView.ScaleType actualType = ((ImageView)this.actual).getScaleType();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)actualType).overridingErrorMessage("Expected scale type <%s> but was <%s>.", new Object[]{type, actualType})).isEqualTo((Object)type);
        return this;
    }
}

