/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.widget;

import android.annotation.TargetApi;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.widget.TextView;
import java.util.regex.Pattern;
import org.assertj.android.api.view.AbstractViewAssert;
import org.assertj.android.internal.IntegerUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

public abstract class AbstractTextViewAssert<S extends AbstractTextViewAssert<S, A>, A extends TextView>
extends AbstractViewAssert<S, A> {
    protected AbstractTextViewAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasAutoLinkMask(int mask) {
        this.isNotNull();
        int actualMask = ((TextView)this.actual).getAutoLinkMask();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualMask).overridingErrorMessage("Expected auto-link mask <%s> but was <%s>.", new Object[]{mask, actualMask})).isEqualTo(mask);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasCompoundDrawablePadding(int padding) {
        this.isNotNull();
        int actualPadding = ((TextView)this.actual).getCompoundDrawablePadding();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected compound drawable padding <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasCompoundPaddingBottom(int padding) {
        this.isNotNull();
        int actualPadding = ((TextView)this.actual).getCompoundPaddingBottom();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected compound drawable bottom padding <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    @TargetApi(value=17)
    public S hasCompoundPaddingEnd(int padding) {
        this.isNotNull();
        int actualPadding = ((TextView)this.actual).getCompoundPaddingEnd();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected compound drawable end padding <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasCompoundPaddingLeft(int padding) {
        this.isNotNull();
        int actualPadding = ((TextView)this.actual).getCompoundPaddingLeft();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected compound drawable left padding <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasCompoundPaddingRight(int padding) {
        this.isNotNull();
        int actualPadding = ((TextView)this.actual).getCompoundPaddingRight();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected compound drawable right padding <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    @TargetApi(value=17)
    public S hasCompoundPaddingStart(int padding) {
        this.isNotNull();
        int actualPadding = ((TextView)this.actual).getCompoundPaddingStart();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected compound drawable start padding <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasCompoundPaddingTop(int padding) {
        this.isNotNull();
        int actualPadding = ((TextView)this.actual).getCompoundPaddingTop();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected compound drawable top padding <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasCurrentHintTextColor(int color) {
        this.isNotNull();
        int actualColor = ((TextView)this.actual).getCurrentHintTextColor();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualColor).overridingErrorMessage("Expected current hint text color <%s> but was <%s>.", new Object[]{Integer.toHexString(color), Integer.toHexString(actualColor)})).isEqualTo(color);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasCurrentTextColor(int color) {
        this.isNotNull();
        int actualColor = ((TextView)this.actual).getCurrentTextColor();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualColor).overridingErrorMessage("Expected current text color <%s> but was <%s>.", new Object[]{Integer.toHexString(color), Integer.toHexString(actualColor)})).isEqualTo(color);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasEllipsize(TextUtils.TruncateAt truncation) {
        this.isNotNull();
        TextUtils.TruncateAt actualTruncation = ((TextView)this.actual).getEllipsize();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)actualTruncation).overridingErrorMessage("Expected ellipsize <%s> but was <%s>.", new Object[]{truncation, actualTruncation})).isEqualTo((Object)truncation);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasError() {
        this.isNotNull();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)((TextView)this.actual).getError()).overridingErrorMessage("Expected error but had none.", new Object[0])).isNotNull();
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasNoError() {
        this.isNotNull();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)((TextView)this.actual).getError()).overridingErrorMessage("Expected no error but had one.", new Object[0])).isNull();
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasError(CharSequence error) {
        this.isNotNull();
        CharSequence actualError = ((TextView)this.actual).getError();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)actualError).overridingErrorMessage("Expected error <%s> but was <%s>.", new Object[]{error, actualError})).isEqualTo((Object)error);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasError(int resId) {
        this.isNotNull();
        return this.hasError(((TextView)this.actual).getContext().getString(resId));
    }

    public S hasExtendedPaddingBottom(int padding) {
        this.isNotNull();
        int actualPadding = ((TextView)this.actual).getExtendedPaddingBottom();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected extended bottom padding <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasExtendedPaddingTop(int padding) {
        this.isNotNull();
        int actualPadding = ((TextView)this.actual).getExtendedPaddingTop();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected extended top padding <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasFreezesText(boolean freezes) {
        this.isNotNull();
        boolean actualFreezes = ((TextView)this.actual).getFreezesText();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)actualFreezes).overridingErrorMessage("Expected freezes text <%s> but was <%s>.", new Object[]{freezes, actualFreezes})).isEqualTo(freezes);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasGravity(int gravity) {
        this.isNotNull();
        int actualGravity = ((TextView)this.actual).getGravity();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualGravity).overridingErrorMessage("Expected gravity <%s> but was <%s>.", new Object[]{AbstractTextViewAssert.gravityToString(gravity), AbstractTextViewAssert.gravityToString(actualGravity)})).isEqualTo(gravity);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    @TargetApi(value=16)
    public S hasHighlightColor(int color) {
        this.isNotNull();
        int actualColor = ((TextView)this.actual).getHighlightColor();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualColor).overridingErrorMessage("Expected highlight color <%s> but was <%s>.", new Object[]{Integer.toHexString(color), Integer.toHexString(actualColor)})).isEqualTo(color);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasHint(CharSequence hint) {
        this.isNotNull();
        CharSequence actualHint = ((TextView)this.actual).getHint();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)actualHint).overridingErrorMessage("Expected hint <%s> but was <%s>.", new Object[]{hint, actualHint})).isEqualTo((Object)hint);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasHint(int resId) {
        this.isNotNull();
        return this.hasHint(((TextView)this.actual).getContext().getString(resId));
    }

    public S hasImeActionId(int id) {
        this.isNotNull();
        int actualId = ((TextView)this.actual).getImeActionId();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected IME action ID <%s> but was <%s>.", new Object[]{id, actualId})).isEqualTo(id);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasImeActionLabel(CharSequence label) {
        this.isNotNull();
        CharSequence actualLabel = ((TextView)this.actual).getImeActionLabel();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)actualLabel).overridingErrorMessage("Expected IME action label <%s> but was <%s>.", new Object[]{label, actualLabel})).isEqualTo((Object)label);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasImeActionLabel(int resId) {
        this.isNotNull();
        return this.hasImeActionLabel(((TextView)this.actual).getContext().getString(resId));
    }

    public S hasImeOptions(int options) {
        this.isNotNull();
        int actualOptions = ((TextView)this.actual).getImeOptions();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualOptions).overridingErrorMessage("Expected IME options <%s> but was <%s>.", new Object[]{AbstractTextViewAssert.imeOptionsToString(options), AbstractTextViewAssert.imeOptionsToString(actualOptions)})).isEqualTo(options);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    @TargetApi(value=16)
    public S isIncludingFontPadding() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((TextView)this.actual).getIncludeFontPadding()).overridingErrorMessage("Expected to be including font padding but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    @TargetApi(value=16)
    public S isNotIncludingFontPadding() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((TextView)this.actual).getIncludeFontPadding()).overridingErrorMessage("Expected to not be including font padding but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasInputType(int type) {
        this.isNotNull();
        int actualType = ((TextView)this.actual).getInputType();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualType).overridingErrorMessage("Expected input type <%s> but was <%s>.", new Object[]{type, actualType})).isEqualTo(type);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasLineCount(int count) {
        this.isNotNull();
        int actualCount = ((TextView)this.actual).getLineCount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected line count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasLineHeight(int height) {
        this.isNotNull();
        int actualHeight = ((TextView)this.actual).getLineHeight();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected line height <%s> but was <%s>.", new Object[]{height, actualHeight})).isEqualTo(height);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    @TargetApi(value=16)
    public S hasLineSpacingExtra(float extra) {
        this.isNotNull();
        float actualExtra = ((TextView)this.actual).getLineSpacingExtra();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualExtra).overridingErrorMessage("Expected line spacing extra <%s> but was <%s>.", new Object[]{Float.valueOf(extra), Float.valueOf(actualExtra)})).isEqualTo(extra);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    @TargetApi(value=16)
    public S hasLineSpacingMultiplier(float multiplier) {
        this.isNotNull();
        float actualMultiplier = ((TextView)this.actual).getLineSpacingMultiplier();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualMultiplier).overridingErrorMessage("Expected line spacing multiplier <%s> but was <%s>.", new Object[]{Float.valueOf(multiplier), Float.valueOf(actualMultiplier)})).isEqualTo(multiplier);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    @TargetApi(value=16)
    public S hasMarqueeRepeatLimit(int limit) {
        this.isNotNull();
        int actualLimit = ((TextView)this.actual).getMarqueeRepeatLimit();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualLimit).overridingErrorMessage("Expected marquee repeat limit <%s> but was <%s>.", new Object[]{limit, actualLimit})).isEqualTo(limit);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    @TargetApi(value=16)
    public S hasMaxEms(int ems) {
        this.isNotNull();
        int actualEms = ((TextView)this.actual).getMaxEms();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualEms).overridingErrorMessage("Expected maximum EMs <%s> but was <%s>.", new Object[]{ems, actualEms})).isEqualTo(ems);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    @TargetApi(value=16)
    public S hasMaxHeight(int height) {
        this.isNotNull();
        int actualHeight = ((TextView)this.actual).getMaxHeight();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected maximum height <%s> but was <%s>.", new Object[]{height, actualHeight})).isEqualTo(height);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    @TargetApi(value=16)
    public S hasMaxLines(int lines) {
        this.isNotNull();
        int actualLines = ((TextView)this.actual).getMaxLines();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualLines).overridingErrorMessage("Expected maximum lines <%s> but was <%s>.", new Object[]{lines, actualLines})).isEqualTo(lines);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    @TargetApi(value=16)
    public S hasMaxWidth(int ems) {
        this.isNotNull();
        int actualWidth = ((TextView)this.actual).getMaxWidth();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected maximum width <%s> but was <%s>.", new Object[]{ems, actualWidth})).isEqualTo(ems);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    @TargetApi(value=16)
    public S hasMinEms(int ems) {
        this.isNotNull();
        int actualEms = ((TextView)this.actual).getMinEms();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualEms).overridingErrorMessage("Expected minimum EMs <%s> but was <%s>.", new Object[]{ems, actualEms})).isEqualTo(ems);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    @TargetApi(value=16)
    public S hasMinHeight(int height) {
        this.isNotNull();
        int actualHeight = ((TextView)this.actual).getMinHeight();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected minimum height <%s> but was <%s>.", new Object[]{height, actualHeight})).isEqualTo(height);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    @TargetApi(value=16)
    public S hasMinLines(int lines) {
        this.isNotNull();
        int actualLines = ((TextView)this.actual).getMinLines();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualLines).overridingErrorMessage("Expected minimum lines <%s> but was <%s>.", new Object[]{lines, actualLines})).isEqualTo(lines);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    @TargetApi(value=16)
    public S hasMinWidth(int ems) {
        this.isNotNull();
        int actualWidth = ((TextView)this.actual).getMinWidth();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected minimum width <%s> but was <%s>.", new Object[]{ems, actualWidth})).isEqualTo(ems);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasPaintFlags(int flags) {
        this.isNotNull();
        int actualFlags = ((TextView)this.actual).getPaintFlags();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualFlags).overridingErrorMessage("Expected paint flags <%s> but was <%s>.", new Object[]{flags, actualFlags})).isEqualTo(flags);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasSelectionEnd(int position) {
        this.isNotNull();
        int actualPosition = ((TextView)this.actual).getSelectionEnd();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPosition).overridingErrorMessage("Expected selection end <%s> but was <%s>.", new Object[]{position, actualPosition})).isEqualTo(position);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasSelectionStart(int position) {
        this.isNotNull();
        int actualPosition = ((TextView)this.actual).getSelectionStart();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPosition).overridingErrorMessage("Expected selection start <%s> but was <%s>.", new Object[]{position, actualPosition})).isEqualTo(position);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    @TargetApi(value=16)
    public S hasShadowColor(int color) {
        this.isNotNull();
        int actualColor = ((TextView)this.actual).getShadowColor();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualColor).overridingErrorMessage("Expected shadow color <%s> but was <%s>.", new Object[]{Integer.toHexString(color), Integer.toHexString(actualColor)})).isEqualTo(color);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    @TargetApi(value=16)
    public S hasShadowDx(float dx) {
        this.isNotNull();
        float actualDx = ((TextView)this.actual).getShadowDx();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualDx).overridingErrorMessage("Expected shadow DX <%s> but was <%s>.", new Object[]{Float.valueOf(dx), Float.valueOf(actualDx)})).isEqualTo(dx);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    @TargetApi(value=16)
    public S hasShadowDy(float dy) {
        this.isNotNull();
        float actualDy = ((TextView)this.actual).getShadowDy();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualDy).overridingErrorMessage("Expected shadow DY <%s> but was <%s>.", new Object[]{Float.valueOf(dy), Float.valueOf(actualDy)})).isEqualTo(dy);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    @TargetApi(value=16)
    public S hasShadowRadius(float radius) {
        this.isNotNull();
        float actualRadius = ((TextView)this.actual).getShadowRadius();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualRadius).overridingErrorMessage("Expected shadow radius <%s> but was <%s>.", new Object[]{Float.valueOf(radius), Float.valueOf(actualRadius)})).isEqualTo(radius);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasText(CharSequence text) {
        this.isNotNull();
        CharSequence actualText = ((TextView)this.actual).getText();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)actualText).overridingErrorMessage("Expected text <%s> but was <%s>.", new Object[]{text, actualText})).isEqualTo((Object)text);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasText(int resId) {
        this.isNotNull();
        return this.hasText(((TextView)this.actual).getContext().getString(resId));
    }

    public S hasTextString(String text) {
        this.isNotNull();
        String actualText = ((TextView)this.actual).getText().toString();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualText).overridingErrorMessage("Expected text string <%s> but was <%s>.", new Object[]{text, actualText})).isEqualTo((Object)text);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasTextString(int resId) {
        this.isNotNull();
        return this.hasTextString(((TextView)this.actual).getContext().getString(resId));
    }

    public S isEmpty() {
        this.isNotNull();
        return this.hasTextString("");
    }

    public S isNotEmpty() {
        this.isNotNull();
        CharSequence text = ((TextView)this.actual).getText();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)text).overridingErrorMessage("Expected empty text but was <%s>.", new Object[]{text})).isNotEqualTo((Object)"");
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S matches(Pattern pattern) {
        this.isNotNull();
        String text = ((TextView)this.actual).getText().toString();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)pattern.matcher(text).matches()).overridingErrorMessage("Expected text <%s> to match <%s>, but did not.", new Object[]{text, pattern.pattern()})).isTrue();
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S doesNotMatch(Pattern pattern) {
        this.isNotNull();
        String text = ((TextView)this.actual).getText().toString();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)pattern.matcher(text).matches()).overridingErrorMessage("Expected text <%s> to not match <%s>, but did.", new Object[]{text, pattern.pattern()})).isFalse();
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S containsText(String sequence) {
        this.isNotNull();
        Assertions.assertThat((String)((TextView)this.actual).getText().toString()).contains(new CharSequence[]{sequence});
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S containsText(int resId) {
        this.isNotNull();
        return this.containsText(((TextView)this.actual).getContext().getString(resId));
    }

    public S doesNotContainText(String sequence) {
        this.isNotNull();
        Assertions.assertThat((String)((TextView)this.actual).getText().toString()).doesNotContain((CharSequence)sequence);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S doesNotContainText(int resId) {
        this.isNotNull();
        return this.doesNotContainText(((TextView)this.actual).getContext().getString(resId));
    }

    public S startsWithText(String sequence) {
        this.isNotNull();
        String text = ((TextView)this.actual).getText().toString();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)text.startsWith(sequence)).overridingErrorMessage("Expected text <%s> to start with <%s> but did not.", new Object[]{text, sequence})).isTrue();
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S startsWithText(int resId) {
        this.isNotNull();
        return this.startsWithText(((TextView)this.actual).getContext().getString(resId));
    }

    public S doesNotStartWithText(String sequence) {
        this.isNotNull();
        String text = ((TextView)this.actual).getText().toString();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)text.startsWith(sequence)).overridingErrorMessage("Expected text <%s> to not start with <%s> but did.", new Object[]{text, sequence})).isFalse();
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S doesNotStartWithText(int resId) {
        this.isNotNull();
        return this.doesNotStartWithText(((TextView)this.actual).getContext().getString(resId));
    }

    public S endsWithText(String sequence) {
        this.isNotNull();
        String text = ((TextView)this.actual).getText().toString();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)text.endsWith(sequence)).overridingErrorMessage("Expected text <%s> to end with <%s> but did not.", new Object[]{text, sequence})).isTrue();
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S endsWithText(int resId) {
        this.isNotNull();
        return this.endsWithText(((TextView)this.actual).getContext().getString(resId));
    }

    public S doesNotEndWithText(String sequence) {
        this.isNotNull();
        String text = ((TextView)this.actual).getText().toString();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)text.endsWith(sequence)).overridingErrorMessage("Expected text <%s> to not end with <%s> but did.", new Object[]{text, sequence})).isFalse();
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S doesNotEndWithText(int resId) {
        this.isNotNull();
        return this.doesNotEndWithText(((TextView)this.actual).getContext().getString(resId));
    }

    public S hasTextScaleX(float scale) {
        this.isNotNull();
        float actualScale = ((TextView)this.actual).getTextScaleX();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualScale).overridingErrorMessage("Expected text X scale <%s> but was <%s>.", new Object[]{Float.valueOf(scale), Float.valueOf(actualScale)})).isEqualTo(scale);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasTextSize(float size) {
        this.isNotNull();
        float actualSize = ((TextView)this.actual).getTextSize();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualSize).overridingErrorMessage("Expected text size <%s> but was <%s>.", new Object[]{Float.valueOf(size), Float.valueOf(actualSize)})).isEqualTo(size);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasTotalPaddingBottom(int padding) {
        this.isNotNull();
        int actualPadding = ((TextView)this.actual).getTotalPaddingBottom();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected total bottom padding <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    @TargetApi(value=17)
    public S hasTotalPaddingEnd(int padding) {
        this.isNotNull();
        int actualPadding = ((TextView)this.actual).getTotalPaddingEnd();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected total end padding <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasTotalPaddingLeft(int padding) {
        this.isNotNull();
        int actualPadding = ((TextView)this.actual).getTotalPaddingLeft();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected total left padding <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasTotalPaddingRight(int padding) {
        this.isNotNull();
        int actualPadding = ((TextView)this.actual).getTotalPaddingRight();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected total right padding <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    @TargetApi(value=17)
    public S hasTotalPaddingStart(int padding) {
        this.isNotNull();
        int actualPadding = ((TextView)this.actual).getTotalPaddingStart();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected total start padding <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasTotalPaddingTop(int padding) {
        this.isNotNull();
        int actualPadding = ((TextView)this.actual).getTotalPaddingTop();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected total top padding <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasTypeface(Typeface typeface) {
        this.isNotNull();
        Typeface actualTypeface = ((TextView)this.actual).getTypeface();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualTypeface).overridingErrorMessage("Expected typeface <%s> but was <%s>.", new Object[]{typeface, actualTypeface})).isSameAs((Object)typeface);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    @TargetApi(value=16)
    public S isCursorVisible() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((TextView)this.actual).isCursorVisible()).overridingErrorMessage("Expected cursor to be visible but was not visible.", new Object[0])).isTrue();
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    @TargetApi(value=16)
    public S isCursorNotVisible() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((TextView)this.actual).isCursorVisible()).overridingErrorMessage("Expected cursor to not be visible but was visible.", new Object[0])).isFalse();
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    @TargetApi(value=11)
    public S hasSelectableText() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((TextView)this.actual).isTextSelectable()).overridingErrorMessage("Expected text to be selectable but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    @TargetApi(value=11)
    public S hasUnselectableText() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((TextView)this.actual).isTextSelectable()).overridingErrorMessage("Expected text to not be selectable but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasLength(int length) {
        this.isNotNull();
        int actualLength = ((TextView)this.actual).length();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualLength).overridingErrorMessage("Expected length <%s> but was <%s>.", new Object[]{length, actualLength})).isEqualTo(length);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S isInputMethodTarget() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((TextView)this.actual).isInputMethodTarget()).overridingErrorMessage("Expected to be the input method target but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S isNotInputMethodTarget() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((TextView)this.actual).isInputMethodTarget()).overridingErrorMessage("Expected to not be the input method target but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public static String gravityToString(int gravity) {
        return IntegerUtils.buildBitMaskString(gravity).flag(0, "no_gravity").flag(48, "top").flag(80, "bottom").flag(3, "left").flag(5, "right").flag(16, "center_vertical").flag(112, "fill_vertical").flag(1, "center_horizontal").flag(7, "fill_horizontal").flag(17, "center").flag(119, "fill").flag(128, "clip_vertical").flag(8, "clip_horizontal").flag(0x800003, "start").flag(0x800005, "end").get();
    }

    public static String imeOptionsToString(int options) {
        return IntegerUtils.buildBitMaskString(options).flag(0, "action_unspecified").flag(1, "action_none").flag(2, "action_go").flag(3, "action_search").flag(4, "action_send").flag(5, "action_next").flag(6, "action_done").flag(7, "action_previous").flag(0x2000000, "flag_no_fullscreen").flag(0x4000000, "flag_navigate_previous").flag(0x8000000, "flag_navigate_next").flag(0x10000000, "flag_no_extract_ui").flag(0x20000000, "flag_no_accessory_action").flag(0x40000000, "flag_no_enter_action").flag(Integer.MIN_VALUE, "flag_force_ascii").flag(0, "null").get();
    }
}

