/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.widget;

import android.graphics.drawable.Drawable;
import android.view.animation.Interpolator;
import android.widget.ProgressBar;
import org.assertj.android.api.view.AbstractViewAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

public abstract class AbstractProgressBarAssert<S extends AbstractProgressBarAssert<S, A>, A extends ProgressBar>
extends AbstractViewAssert<S, A> {
    protected AbstractProgressBarAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasIndeterminateDrawable(Drawable drawable) {
        this.isNotNull();
        Drawable actualDrawable = ((ProgressBar)this.actual).getIndeterminateDrawable();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualDrawable).overridingErrorMessage("Expected indeterminate drawable <%s> but was <%s>.", new Object[]{drawable, actualDrawable})).isSameAs((Object)drawable);
        return (S)((Object)((AbstractProgressBarAssert)this.myself));
    }

    public S hasInterpolator(Interpolator interpolator) {
        this.isNotNull();
        Interpolator actualInterpolator = ((ProgressBar)this.actual).getInterpolator();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualInterpolator).overridingErrorMessage("Expected interpolator <%s> but was <%s>.", new Object[]{interpolator, actualInterpolator})).isSameAs((Object)interpolator);
        return (S)((Object)((AbstractProgressBarAssert)this.myself));
    }

    public S hasMaximum(int maximum) {
        this.isNotNull();
        int actualMaximum = ((ProgressBar)this.actual).getMax();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualMaximum).overridingErrorMessage("Expected maximum <%s> but was <%s>.", new Object[]{maximum, actualMaximum})).isEqualTo(maximum);
        return (S)((Object)((AbstractProgressBarAssert)this.myself));
    }

    public S hasProgress(int progress) {
        this.isNotNull();
        int actualProgress = ((ProgressBar)this.actual).getProgress();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualProgress).overridingErrorMessage("Expected progress <%s> but was <%s>.", new Object[]{progress, actualProgress})).isEqualTo(progress);
        return (S)((Object)((AbstractProgressBarAssert)this.myself));
    }

    public S hasProgressDrawable(Drawable drawable) {
        this.isNotNull();
        Drawable actualDrawable = ((ProgressBar)this.actual).getProgressDrawable();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualDrawable).overridingErrorMessage("Expected progress drawable <%s> but was <%s>.", new Object[]{drawable, actualDrawable})).isSameAs((Object)drawable);
        return (S)((Object)((AbstractProgressBarAssert)this.myself));
    }

    public S hasSecondaryProgress(int progress) {
        this.isNotNull();
        int actualProgress = ((ProgressBar)this.actual).getSecondaryProgress();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualProgress).overridingErrorMessage("Expected secondary progress <%s> but was <%s>.", new Object[]{progress, actualProgress})).isEqualTo(progress);
        return (S)((Object)((AbstractProgressBarAssert)this.myself));
    }

    public S isIndeterminate() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ProgressBar)this.actual).isIndeterminate()).overridingErrorMessage("Expected to be indeterminate but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractProgressBarAssert)this.myself));
    }

    public S isNotIndeterminate() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ProgressBar)this.actual).isIndeterminate()).overridingErrorMessage("Expected to not be indeterminate but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractProgressBarAssert)this.myself));
    }
}

