/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.widget;

import android.annotation.TargetApi;
import android.graphics.drawable.Drawable;
import android.widget.ListView;
import org.assertj.android.api.widget.AbstractAbsListViewAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

public abstract class AbstractListViewAssert<S extends AbstractListViewAssert<S, A>, A extends ListView>
extends AbstractAbsListViewAssert<S, A> {
    protected AbstractListViewAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasDivider(Drawable divider) {
        this.isNotNull();
        Drawable actualDivider = ((ListView)this.actual).getDivider();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualDivider).overridingErrorMessage("Expected divider <%s> but was <%s>.", new Object[]{divider, actualDivider})).isSameAs((Object)divider);
        return (S)((Object)((AbstractListViewAssert)this.myself));
    }

    public S hasDividerHeight(int height) {
        this.isNotNull();
        int actualHeight = ((ListView)this.actual).getDividerHeight();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected divider height <%s> but was <%s>.", new Object[]{height, actualHeight})).isEqualTo(height);
        return (S)((Object)((AbstractListViewAssert)this.myself));
    }

    public S hasFooterViewsCount(int count) {
        this.isNotNull();
        int actualCount = ((ListView)this.actual).getFooterViewsCount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected footer views count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return (S)((Object)((AbstractListViewAssert)this.myself));
    }

    public S hasHeaderViewsCount(int count) {
        this.isNotNull();
        int actualCount = ((ListView)this.actual).getHeaderViewsCount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected header views count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return (S)((Object)((AbstractListViewAssert)this.myself));
    }

    @TargetApi(value=9)
    public S hasOverscrollFooter(Drawable footer) {
        this.isNotNull();
        Drawable actualFooter = ((ListView)this.actual).getOverscrollFooter();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualFooter).overridingErrorMessage("Expected overscroll footer <%s> but was <%s>.", new Object[]{footer, actualFooter})).isSameAs((Object)footer);
        return (S)((Object)((AbstractListViewAssert)this.myself));
    }

    @TargetApi(value=9)
    public S hasOverscrollHeader(Drawable header) {
        this.isNotNull();
        Drawable actualHeader = ((ListView)this.actual).getOverscrollHeader();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualHeader).overridingErrorMessage("Expected overscroll header <%s> but was <%s>.", new Object[]{header, actualHeader})).isSameAs((Object)header);
        return (S)((Object)((AbstractListViewAssert)this.myself));
    }

    @TargetApi(value=19)
    public S hasFooterDividersEnabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ListView)this.actual).areFooterDividersEnabled()).overridingErrorMessage("Expected to have footer dividers enabled but were not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractListViewAssert)this.myself));
    }

    @TargetApi(value=19)
    public S hasFooterDividersDisabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ListView)this.actual).areFooterDividersEnabled()).overridingErrorMessage("Expected to have footer dividers disabled but were not.", new Object[0])).isFalse();
        return (S)((Object)((AbstractListViewAssert)this.myself));
    }

    @TargetApi(value=19)
    public S hasHeaderDividersEnabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ListView)this.actual).areHeaderDividersEnabled()).overridingErrorMessage("Expected to have header dividers enabled but were not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractListViewAssert)this.myself));
    }

    @TargetApi(value=19)
    public S hasHeaderDividersDisabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ListView)this.actual).areHeaderDividersEnabled()).overridingErrorMessage("Expected to have header dividers disabled but were not.", new Object[0])).isFalse();
        return (S)((Object)((AbstractListViewAssert)this.myself));
    }
}

