/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.widget;

import android.annotation.TargetApi;
import android.widget.LinearLayout;
import org.assertj.android.api.view.AbstractViewGroupAssert;
import org.assertj.android.internal.IntegerUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public abstract class AbstractLinearLayoutAssert<S extends AbstractLinearLayoutAssert<S, A>, A extends LinearLayout>
extends AbstractViewGroupAssert<S, A> {
    protected AbstractLinearLayoutAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    @TargetApi(value=14)
    public S hasDividerPadding(int padding) {
        this.isNotNull();
        int actualPadding = ((LinearLayout)this.actual).getDividerPadding();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected divider padding <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractLinearLayoutAssert)this.myself));
    }

    public S hasOrientation(int orientation) {
        this.isNotNull();
        int actualOrientation = ((LinearLayout)this.actual).getOrientation();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualOrientation).overridingErrorMessage("Expected orientation <%s> but was <%s>.", new Object[]{AbstractLinearLayoutAssert.orientationToString(orientation), AbstractLinearLayoutAssert.orientationToString(actualOrientation)})).isEqualTo(orientation);
        return (S)((Object)((AbstractLinearLayoutAssert)this.myself));
    }

    public S isVertical() {
        return this.hasOrientation(1);
    }

    public S isHorizontal() {
        return this.hasOrientation(0);
    }

    @TargetApi(value=11)
    public S hasShowDividers(int dividers) {
        this.isNotNull();
        int actualDividers = ((LinearLayout)this.actual).getShowDividers();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualDividers).overridingErrorMessage("Expected showing dividers <%s> but was <%s>.", new Object[]{AbstractLinearLayoutAssert.showDividerToString(dividers), AbstractLinearLayoutAssert.showDividerToString(actualDividers)})).isEqualTo(dividers);
        return (S)((Object)((AbstractLinearLayoutAssert)this.myself));
    }

    public S hasWeightSum(float sum) {
        this.isNotNull();
        float actualSum = ((LinearLayout)this.actual).getWeightSum();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualSum).overridingErrorMessage("Expected weight sum <%s> but was <%s>.", new Object[]{Float.valueOf(sum), Float.valueOf(actualSum)})).isEqualTo(sum);
        return (S)((Object)((AbstractLinearLayoutAssert)this.myself));
    }

    public S isBaselineAligned() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((LinearLayout)this.actual).isBaselineAligned()).overridingErrorMessage("Expected to be baseline aligned but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractLinearLayoutAssert)this.myself));
    }

    public S isNotBaselineAligned() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((LinearLayout)this.actual).isBaselineAligned()).overridingErrorMessage("Expected to not be baseline aligned but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractLinearLayoutAssert)this.myself));
    }

    @TargetApi(value=11)
    public S isMeasuringWithLargestChild() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((LinearLayout)this.actual).isMeasureWithLargestChildEnabled()).overridingErrorMessage("Expected to be measuring with largest child but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractLinearLayoutAssert)this.myself));
    }

    @TargetApi(value=11)
    public S isNotMeasuringWithLargestChild() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((LinearLayout)this.actual).isMeasureWithLargestChildEnabled()).overridingErrorMessage("Expected to not be measuring with largest child but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractLinearLayoutAssert)this.myself));
    }

    @TargetApi(value=11)
    public static String showDividerToString(int dividers) {
        return IntegerUtils.buildBitMaskString(dividers).flag(1, "beginning").flag(2, "middle").flag(4, "end").get();
    }

    public static String orientationToString(int orientation) {
        return IntegerUtils.buildNamedValueString(orientation).value(0, "horizontal").value(1, "vertical").get();
    }
}

