/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.widget;

import android.widget.HorizontalScrollView;
import org.assertj.android.api.widget.AbstractFrameLayoutAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public abstract class AbstractHorizontalScrollViewAssert<S extends AbstractHorizontalScrollViewAssert<S, A>, A extends HorizontalScrollView>
extends AbstractFrameLayoutAssert<S, A> {
    protected AbstractHorizontalScrollViewAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasMaximumScrollAmount(int amount) {
        this.isNotNull();
        int actualAmount = ((HorizontalScrollView)this.actual).getMaxScrollAmount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualAmount).overridingErrorMessage("Expected maximum scroll amount <%s> but was <%s>.", new Object[]{amount, actualAmount})).isEqualTo(amount);
        return (S)((Object)((AbstractHorizontalScrollViewAssert)this.myself));
    }

    public S isFillingViewport() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((HorizontalScrollView)this.actual).isFillViewport()).overridingErrorMessage("Expected to be filling viewport but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractHorizontalScrollViewAssert)this.myself));
    }

    public S isNotFillingViewport() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((HorizontalScrollView)this.actual).isFillViewport()).overridingErrorMessage("Expected to not be filling viewport but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractHorizontalScrollViewAssert)this.myself));
    }

    public S isSmoothScrollingEnabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((HorizontalScrollView)this.actual).isSmoothScrollingEnabled()).overridingErrorMessage("Expected smooth scrolling to be enabled but was disabled.", new Object[0])).isTrue();
        return (S)((Object)((AbstractHorizontalScrollViewAssert)this.myself));
    }

    public S isSmoothScrollingDisabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((HorizontalScrollView)this.actual).isSmoothScrollingEnabled()).overridingErrorMessage("Expected smooth scrolling to be disabled but was enabled.", new Object[0])).isFalse();
        return (S)((Object)((AbstractHorizontalScrollViewAssert)this.myself));
    }
}

