/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.widget;

import android.annotation.TargetApi;
import android.widget.AbsListView;
import org.assertj.android.api.widget.AbstractAdapterViewAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public abstract class AbstractAbsListViewAssert<S extends AbstractAbsListViewAssert<S, A>, A extends AbsListView>
extends AbstractAdapterViewAssert<S, A> {
    public AbstractAbsListViewAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    @TargetApi(value=11)
    public S hasCheckedItemsCount(int count) {
        this.isNotNull();
        int actualCount = ((AbsListView)this.actual).getCheckedItemCount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected <%s> checked items but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return (S)((Object)((AbstractAbsListViewAssert)this.myself));
    }

    @TargetApi(value=11)
    public S containsItemIds(long ... itemIds) {
        this.isNotNull();
        Assertions.assertThat((long[])((AbsListView)this.actual).getCheckedItemIds()).contains(itemIds);
        return (S)((Object)((AbstractAbsListViewAssert)this.myself));
    }

    @TargetApi(value=11)
    public S hasCheckedItemPosition(int position) {
        this.isNotNull();
        Assertions.assertThat((int)((AbsListView)this.actual).getCheckedItemPosition()).isEqualTo(position);
        return (S)((Object)((AbstractAbsListViewAssert)this.myself));
    }

    public S containsCheckedItemPositions(int ... positions) {
        this.isNotNull();
        return (S)((Object)((AbstractAbsListViewAssert)this.myself));
    }

    @TargetApi(value=19)
    public S canScrollList(int direction) {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AbsListView)this.actual).canScrollList(direction)).overridingErrorMessage("Expected to be able to scroll <%s> but cannot.", new Object[]{AbstractAbsListViewAssert.scrollDirectionToString(direction)})).isTrue();
        return (S)((Object)((AbstractAbsListViewAssert)this.myself));
    }

    static String scrollDirectionToString(int direction) {
        if (direction == 0) {
            throw new IllegalArgumentException("direction must be positive or negative");
        }
        if (direction < 0) {
            return "up";
        }
        return "down";
    }
}

