/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.webkit;

import android.annotation.TargetApi;
import android.net.http.SslCertificate;
import android.webkit.WebView;
import org.assertj.android.api.widget.AbstractAbsoluteLayoutAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

public class WebViewAssert
extends AbstractAbsoluteLayoutAssert<WebViewAssert, WebView> {
    public WebViewAssert(WebView actual) {
        super(actual, WebViewAssert.class);
    }

    public WebViewAssert canGoBack() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((WebView)this.actual).canGoBack()).overridingErrorMessage("Expected to be able to go back but could not.", new Object[0])).isTrue();
        return this;
    }

    public WebViewAssert canNotGoBack() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((WebView)this.actual).canGoBack()).overridingErrorMessage("Expected to not be able to go back but could.", new Object[0])).isFalse();
        return this;
    }

    public WebViewAssert canGoForward() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((WebView)this.actual).canGoForward()).overridingErrorMessage("Expected to be able to go forward but could not.", new Object[0])).isTrue();
        return this;
    }

    public WebViewAssert canNotGoForward() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((WebView)this.actual).canGoForward()).overridingErrorMessage("Expected to not be able to go forward but could.", new Object[0])).isFalse();
        return this;
    }

    public WebViewAssert hasCertificate(SslCertificate certificate) {
        this.isNotNull();
        SslCertificate actualCertificate = ((WebView)this.actual).getCertificate();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualCertificate).overridingErrorMessage("Expected certificate <%s> but was <%s>.", new Object[]{certificate, actualCertificate})).isSameAs((Object)certificate);
        return this;
    }

    public WebViewAssert hasContentHeight(int height) {
        this.isNotNull();
        int actualHeight = ((WebView)this.actual).getContentHeight();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected content height <%s> but was <%s>.", new Object[]{height, actualHeight})).isEqualTo(height);
        return this;
    }

    public WebViewAssert hasOriginalUrl(String url) {
        this.isNotNull();
        String actualUrl = ((WebView)this.actual).getOriginalUrl();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualUrl).overridingErrorMessage("Expected original URL <%s> but was <%s>.", new Object[]{url, actualUrl})).isEqualTo((Object)url);
        return this;
    }

    public WebViewAssert hasProgress(int progress) {
        this.isNotNull();
        int actualProgress = ((WebView)this.actual).getProgress();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualProgress).overridingErrorMessage("Expected progress <%s> but was <%s>.", new Object[]{progress, actualProgress})).isEqualTo(progress);
        return this;
    }

    public WebViewAssert hasTitle(String title) {
        this.isNotNull();
        String actualTitle = ((WebView)this.actual).getTitle();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualTitle).overridingErrorMessage("Expected title <%s> but was <%s>.", new Object[]{title, actualTitle})).isEqualTo((Object)title);
        return this;
    }

    public WebViewAssert hasUrl(String url) {
        this.isNotNull();
        String actualUrl = ((WebView)this.actual).getUrl();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualUrl).overridingErrorMessage("Expected URL <%s> but was <%s>.", new Object[]{url, actualUrl})).isEqualTo((Object)url);
        return this;
    }

    @TargetApi(value=11)
    public WebViewAssert isPrivateBrowsingEnabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((WebView)this.actual).isPrivateBrowsingEnabled()).overridingErrorMessage("Expected private browsing to be enabled but was disabled.", new Object[0])).isTrue();
        return this;
    }

    @TargetApi(value=11)
    public WebViewAssert isPrivateBrowsingDisabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((WebView)this.actual).isPrivateBrowsingEnabled()).overridingErrorMessage("Expected private browsing to be disabled but was enabled.", new Object[0])).isFalse();
        return this;
    }
}

