/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.view.animation;

import android.graphics.Matrix;
import android.view.animation.Transformation;
import org.assertj.android.internal.IntegerUtils;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

public class TransformationAssert
extends AbstractAssert<TransformationAssert, Transformation> {
    public TransformationAssert(Transformation actual) {
        super((Object)actual, TransformationAssert.class);
    }

    public TransformationAssert hasAlpha(float alpha) {
        this.isNotNull();
        float actualAlpha = ((Transformation)this.actual).getAlpha();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualAlpha).overridingErrorMessage("Expected alpha <%s> but was <%s>.", new Object[]{Float.valueOf(alpha), Float.valueOf(actualAlpha)})).isEqualTo(alpha);
        return this;
    }

    public TransformationAssert hasMatrix(Matrix matrix) {
        this.isNotNull();
        Matrix actualMatrix = ((Transformation)this.actual).getMatrix();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualMatrix).overridingErrorMessage("Expected matrix <%s> but was <%s>.", new Object[]{matrix, actualMatrix})).isEqualTo((Object)matrix);
        return this;
    }

    public TransformationAssert hasTransformationType(int type) {
        this.isNotNull();
        int actualType = ((Transformation)this.actual).getTransformationType();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualType).overridingErrorMessage("Expected transformation type <%s> but was <%s>.", new Object[]{TransformationAssert.transformationTypeToString(type), TransformationAssert.transformationTypeToString(actualType)})).isEqualTo(type);
        return this;
    }

    public static String transformationTypeToString(int type) {
        return IntegerUtils.buildNamedValueString(type).value(1, "alpha").value(3, "both").value(0, "identity").value(2, "matrix").get();
    }
}

