/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.view;

import android.annotation.TargetApi;
import android.view.View;
import android.view.Window;
import org.assertj.android.internal.IntegerUtils;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

public class WindowAssert
extends AbstractAssert<WindowAssert, Window> {
    public WindowAssert(Window actual) {
        super((Object)actual, WindowAssert.class);
    }

    public WindowAssert hasCurrentFocus(View view) {
        this.isNotNull();
        View actualView = ((Window)this.actual).getCurrentFocus();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualView).overridingErrorMessage("Expected current focused view <%s> but was <%s>.", new Object[]{view, actualView})).isSameAs((Object)view);
        return this;
    }

    public WindowAssert hasChildren() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Window)this.actual).hasChildren()).overridingErrorMessage("Expected children but had no children.", new Object[0])).isTrue();
        return this;
    }

    public WindowAssert hasNoChildren() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Window)this.actual).hasChildren()).overridingErrorMessage("Expected no children but had children.", new Object[0])).isFalse();
        return this;
    }

    @TargetApi(value=11)
    public WindowAssert hasFeature(int feature) {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Window)this.actual).hasFeature(feature)).overridingErrorMessage("Expected feature <%s> but was not present.", new Object[]{WindowAssert.featureToString(feature)})).isTrue();
        return this;
    }

    public WindowAssert isActive() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Window)this.actual).isActive()).overridingErrorMessage("Expected to be active but was not active.", new Object[0])).isTrue();
        return this;
    }

    public WindowAssert isNotActive() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Window)this.actual).isActive()).overridingErrorMessage("Expected to not be active but was active.", new Object[0])).isFalse();
        return this;
    }

    public WindowAssert isFloating() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Window)this.actual).isFloating()).overridingErrorMessage("Expected to be floating but was not floating.", new Object[0])).isTrue();
        return this;
    }

    public WindowAssert isNotFloating() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Window)this.actual).isFloating()).overridingErrorMessage("Expected to not be floating but was floating.", new Object[0])).isFalse();
        return this;
    }

    public static String featureToString(int feature) {
        return IntegerUtils.buildNamedValueString(feature).value(8, "actionBar").value(9, "actionBarOverlay").value(10, "actionModeOverlay").value(6, "contextMenu").value(7, "customTitle").value(5, "indeterminateProgress").value(3, "leftIcon").value(1, "noTitle").value(0, "optionalPanel").value(2, "progress").value(4, "rightIcon").value(11, "swipeToDismiss").get();
    }
}

