/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.view;

import android.annotation.TargetApi;
import android.view.DragEvent;
import org.assertj.android.internal.IntegerUtils;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

@TargetApi(value=11)
public class DragEventAssert
extends AbstractAssert<DragEventAssert, DragEvent> {
    public DragEventAssert(DragEvent actual) {
        super((Object)actual, DragEventAssert.class);
    }

    public DragEventAssert hasAction(int action) {
        this.isNotNull();
        int actualAction = ((DragEvent)this.actual).getAction();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualAction).overridingErrorMessage("Expected action <%s> but was <%s>", new Object[]{DragEventAssert.dragEventActionToString(action), DragEventAssert.dragEventActionToString(actualAction)})).isEqualTo(action);
        return this;
    }

    public DragEventAssert hasLocalState(Object localState) {
        this.isNotNull();
        Object actualLocalState = ((DragEvent)this.actual).getLocalState();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualLocalState).overridingErrorMessage("Expected local state <%s> but was <%s>", new Object[]{localState, actualLocalState})).isEqualTo(localState);
        return this;
    }

    public DragEventAssert hasSuccessfulResult() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((DragEvent)this.actual).getResult()).overridingErrorMessage("Expected successful result but was unsuccessful", new Object[0])).isTrue();
        return this;
    }

    public DragEventAssert hasUnsuccessfulResult() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((DragEvent)this.actual).getResult()).overridingErrorMessage("Expected unsuccessful result but was successful", new Object[0])).isFalse();
        return this;
    }

    public DragEventAssert hasX(float x) {
        this.isNotNull();
        float actualX = ((DragEvent)this.actual).getX();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualX).overridingErrorMessage("Expected X <%s> but was <%s>", new Object[]{Float.valueOf(x), Float.valueOf(actualX)})).isEqualTo(x);
        return this;
    }

    public DragEventAssert hasY(float y) {
        this.isNotNull();
        float actualY = ((DragEvent)this.actual).getY();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualY).overridingErrorMessage("Expected Y <%s> but was <%s>", new Object[]{Float.valueOf(y), Float.valueOf(actualY)})).isEqualTo(y);
        return this;
    }

    public static String dragEventActionToString(int action) {
        return IntegerUtils.buildNamedValueString(action).value(4, "drag ended").value(5, "drag entered").value(6, "drag exited").value(2, "drag location").value(1, "drag started").value(3, "drop").get();
    }
}

