/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.view;

import android.annotation.TargetApi;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewParent;
import android.view.animation.Animation;
import org.assertj.android.internal.IntegerUtils;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

public abstract class AbstractViewAssert<S extends AbstractViewAssert<S, A>, A extends View>
extends AbstractAssert<S, A> {
    protected AbstractViewAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    @TargetApi(value=11)
    public S hasAlpha(float alpha) {
        this.isNotNull();
        float actualAlpha = ((View)this.actual).getAlpha();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualAlpha).overridingErrorMessage("Expected alpha <%s> but was <%s>", new Object[]{Float.valueOf(alpha), Float.valueOf(actualAlpha)})).isEqualTo(alpha);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasAnimation(Animation animation) {
        this.isNotNull();
        Animation actualAnimation = ((View)this.actual).getAnimation();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualAnimation).overridingErrorMessage("Expected animation <%s> but was <%s>", new Object[]{animation, actualAnimation})).isSameAs((Object)animation);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasBackground(Drawable background) {
        this.isNotNull();
        Drawable actualDrawable = ((View)this.actual).getBackground();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualDrawable).overridingErrorMessage("Expected background <%s> but was <%s>", new Object[]{background, actualDrawable})).isSameAs((Object)background);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasBaseline(int baseline) {
        this.isNotNull();
        int actualBaseline = ((View)this.actual).getBaseline();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualBaseline).overridingErrorMessage("Expected baseline <%s> but was <%s>", new Object[]{baseline, actualBaseline})).isEqualTo(baseline);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasBottom(int bottom) {
        this.isNotNull();
        int actualBottom = ((View)this.actual).getBottom();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualBottom).overridingErrorMessage("Expected bottom <%s> but was <%s>", new Object[]{bottom, actualBottom})).isEqualTo(bottom);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasContentDescription(CharSequence contentDescription) {
        this.isNotNull();
        CharSequence actualContentDescription = ((View)this.actual).getContentDescription();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)actualContentDescription).overridingErrorMessage("Expected content description <%s> but was <%s>", new Object[]{contentDescription, actualContentDescription})).isEqualTo((Object)contentDescription);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasContentDescription(int resId) {
        this.isNotNull();
        return this.hasContentDescription(((View)this.actual).getContext().getString(resId));
    }

    public S hasDrawingCacheBackgroundColor(int color) {
        this.isNotNull();
        int actualColor = ((View)this.actual).getDrawingCacheBackgroundColor();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualColor).overridingErrorMessage("Expected drawing cache background color <%s> but was <%s>", new Object[]{Integer.toHexString(color), Integer.toHexString(actualColor)})).isEqualTo(color);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasDrawingCacheQuality(int quality) {
        this.isNotNull();
        int actualQuality = ((View)this.actual).getDrawingCacheQuality();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualQuality).overridingErrorMessage("Expected drawing cache quality <%s> but was <%s>", new Object[]{quality, actualQuality})).isEqualTo(quality);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasHeight(int height) {
        this.isNotNull();
        int actualHeight = ((View)this.actual).getHeight();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected height <%s> but was <%s>", new Object[]{height, actualHeight})).isEqualTo(height);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasHorizontalFadingEdgeLength(int length) {
        this.isNotNull();
        int actualLength = ((View)this.actual).getHorizontalFadingEdgeLength();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualLength).overridingErrorMessage("Expected horizontal fading edge length <%s> but was <%s>", new Object[]{length, actualLength})).isEqualTo(length);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasId(int id) {
        this.isNotNull();
        int actualId = ((View)this.actual).getId();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected ID <%s> but was <%s>", new Object[]{Integer.toHexString(id), Integer.toHexString(actualId)})).isEqualTo(id);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isKeepingScreenOn() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).getKeepScreenOn()).overridingErrorMessage("Expected to be keeping screen on but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotKeepingScreenOn() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).getKeepScreenOn()).overridingErrorMessage("Expected to not be keeping screen on but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=17)
    public S hasLabelFor(int id) {
        this.isNotNull();
        int actualId = ((View)this.actual).getLabelFor();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected to have label for ID <%s> but was <%s>", new Object[]{id, actualId})).isEqualTo(id);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=11)
    public S hasLayerType(int type) {
        this.isNotNull();
        int actualType = ((View)this.actual).getLayerType();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualType).overridingErrorMessage("Expected layer type <%s> but was <%s>", new Object[]{AbstractViewAssert.layerTypeToString(type), AbstractViewAssert.layerTypeToString(actualType)})).isEqualTo(type);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=17)
    public S hasLayoutDirection(int direction) {
        this.isNotNull();
        int actualDirection = ((View)this.actual).getLayoutDirection();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualDirection).overridingErrorMessage("Expected layout direction <%s> but was <%s>", new Object[]{AbstractViewAssert.layoutDirectionToString(direction), AbstractViewAssert.layoutDirectionToString(actualDirection)})).isEqualTo(direction);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasLeft(int left) {
        this.isNotNull();
        int actualLeft = ((View)this.actual).getLeft();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualLeft).overridingErrorMessage("Expected left <%s> but was <%s>", new Object[]{left, actualLeft})).isEqualTo(left);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasMeasuredHeight(int height) {
        this.isNotNull();
        int actualHeight = ((View)this.actual).getMeasuredHeight();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected measured height <%s> but was <%s>", new Object[]{height, actualHeight})).isEqualTo(height);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=11)
    public S hasMeasuredHeightAndState(int heightAndState) {
        this.isNotNull();
        int actualHeightAndState = ((View)this.actual).getMeasuredHeightAndState();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualHeightAndState).overridingErrorMessage("Expected measured height and state <%s> but was <%s>", new Object[]{heightAndState, actualHeightAndState})).isEqualTo(heightAndState);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=11)
    public S hasMeasuredState(int state) {
        this.isNotNull();
        int actualState = ((View)this.actual).getMeasuredState();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualState).overridingErrorMessage("Expected measured state <%s> but was <%s>", new Object[]{state, actualState})).isEqualTo(state);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasMeasuredWidth(int width) {
        this.isNotNull();
        int actualWidth = ((View)this.actual).getMeasuredWidth();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected measured width <%s> but was <%s>", new Object[]{width, actualWidth})).isEqualTo(width);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=11)
    public S hasMeasuredWidthAndState(int widthAndState) {
        this.isNotNull();
        int actualWidthAndState = ((View)this.actual).getMeasuredWidthAndState();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualWidthAndState).overridingErrorMessage("Expected measured width and state <%s> but was <%s>", new Object[]{widthAndState, actualWidthAndState})).isEqualTo(widthAndState);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=16)
    public S hasMinimumHeight(int height) {
        this.isNotNull();
        int actualHeight = ((View)this.actual).getMinimumHeight();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected minimum height <%s> but was <%s>", new Object[]{height, actualHeight})).isEqualTo(height);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=16)
    public S hasMinimumWidth(int width) {
        this.isNotNull();
        int actualWidth = ((View)this.actual).getMinimumWidth();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected minimum width <%s> but was <%s>", new Object[]{width, actualWidth})).isEqualTo(width);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasNextFocusDownId(int id) {
        this.isNotNull();
        int actualId = ((View)this.actual).getNextFocusDownId();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected next focus down ID <%s> but was <%s>", new Object[]{id, actualId})).isEqualTo(id);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=11)
    public S hasNextFocusForwardId(int id) {
        this.isNotNull();
        int actualId = ((View)this.actual).getNextFocusForwardId();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected next focus forward ID <%s> but was <%s>", new Object[]{id, actualId})).isEqualTo(id);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasNextFocusLeftId(int id) {
        this.isNotNull();
        int actualId = ((View)this.actual).getNextFocusLeftId();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected next focus left ID <%s> but was <%s>", new Object[]{id, actualId})).isEqualTo(id);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasNextFocusRightId(int id) {
        this.isNotNull();
        int actualId = ((View)this.actual).getNextFocusRightId();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected next focus right ID <%s> but was <%s>", new Object[]{id, actualId})).isEqualTo(id);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasNextFocusUpId(int id) {
        this.isNotNull();
        int actualId = ((View)this.actual).getNextFocusUpId();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected next focus up ID <%s> but was <%s>", new Object[]{id, actualId})).isEqualTo(id);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=9)
    public S hasOverScrollMode(int mode) {
        this.isNotNull();
        int actualMode = ((View)this.actual).getOverScrollMode();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualMode).overridingErrorMessage("Expected over scroll mode <%s> but was <%s>", new Object[]{AbstractViewAssert.overScrollModeToString(mode), AbstractViewAssert.overScrollModeToString(actualMode)})).isEqualTo(mode);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasPaddingBottom(int padding) {
        this.isNotNull();
        int actualPadding = ((View)this.actual).getPaddingBottom();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected padding bottom <%s> but was <%s>", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=17)
    public S hasPaddingEnd(int padding) {
        this.isNotNull();
        int actualPadding = ((View)this.actual).getPaddingEnd();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected padding end <%s> but was <%s>", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasPaddingLeft(int padding) {
        this.isNotNull();
        int actualPadding = ((View)this.actual).getPaddingLeft();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected padding left <%s> but was <%s>", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasPaddingRight(int padding) {
        this.isNotNull();
        int actualPadding = ((View)this.actual).getPaddingRight();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected padding right <%s> but was <%s>", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=17)
    public S hasPaddingStart(int padding) {
        this.isNotNull();
        int actualPadding = ((View)this.actual).getPaddingStart();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected padding start <%s> but was <%s>", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasPaddingTop(int padding) {
        this.isNotNull();
        int actualPadding = ((View)this.actual).getPaddingTop();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected padding top <%s> but was <%s>", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasParent(ViewParent parent) {
        this.isNotNull();
        ViewParent actualParent = ((View)this.actual).getParent();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualParent).overridingErrorMessage("Expected parent <%s> but was <%s>", new Object[]{parent, actualParent})).isSameAs((Object)parent);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=16)
    public S hasParentForAccessibility(ViewParent parent) {
        this.isNotNull();
        ViewParent actualParent = ((View)this.actual).getParentForAccessibility();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualParent).overridingErrorMessage("Expected parent for accessibility <%s> but was <%s>", new Object[]{parent, actualParent})).isSameAs((Object)parent);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=11)
    public S hasPivotX(float pivotX) {
        this.isNotNull();
        float actualPivotX = ((View)this.actual).getPivotX();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualPivotX).overridingErrorMessage("Expected x pivot <%s> but was <%s>", new Object[]{Float.valueOf(pivotX), Float.valueOf(actualPivotX)})).isEqualTo(pivotX);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=11)
    public S hasPivotY(float pivotY) {
        this.isNotNull();
        float actualPivotY = ((View)this.actual).getPivotY();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualPivotY).overridingErrorMessage("Expected y pivot <s> but was <%s>", new Object[]{Float.valueOf(pivotY), Float.valueOf(actualPivotY)})).isEqualTo(pivotY);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasRight(int right) {
        this.isNotNull();
        int actualRight = ((View)this.actual).getRight();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualRight).overridingErrorMessage("Expected right <%s> but was <%s>", new Object[]{right, actualRight})).isEqualTo(right);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasRootView(View view) {
        this.isNotNull();
        View actualView = ((View)this.actual).getRootView();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualView).overridingErrorMessage("Expected root view <%s> but was <%s>", new Object[]{view, actualView})).isSameAs((Object)view);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=11)
    public S hasRotation(float rotation) {
        this.isNotNull();
        float actualRotation = ((View)this.actual).getRotation();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualRotation).overridingErrorMessage("Expected rotation <%s> but was <%s>", new Object[]{Float.valueOf(rotation), Float.valueOf(actualRotation)})).isSameAs((Object)Float.valueOf(rotation));
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=11)
    public S hasRotationX(float rotation) {
        this.isNotNull();
        float actualRotation = ((View)this.actual).getRotationX();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualRotation).overridingErrorMessage("Expected x rotation <%s> but was <%s>", new Object[]{Float.valueOf(rotation), Float.valueOf(actualRotation)})).isSameAs((Object)Float.valueOf(rotation));
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=11)
    public S hasRotationY(float rotation) {
        this.isNotNull();
        float actualRotation = ((View)this.actual).getRotationY();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualRotation).overridingErrorMessage("Expected y rotation <%s> but was <%s>", new Object[]{Float.valueOf(rotation), Float.valueOf(actualRotation)})).isSameAs((Object)Float.valueOf(rotation));
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=11)
    public S hasScaleX(float scale) {
        this.isNotNull();
        float actualScale = ((View)this.actual).getScaleX();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualScale).overridingErrorMessage("Expected x scale <%s> but was <%s>", new Object[]{Float.valueOf(scale), Float.valueOf(actualScale)})).isSameAs((Object)Float.valueOf(scale));
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=11)
    public S hasScaleY(float scale) {
        this.isNotNull();
        float actualScale = ((View)this.actual).getScaleY();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualScale).overridingErrorMessage("Expected y scale <%s> but was <%s>", new Object[]{Float.valueOf(scale), Float.valueOf(actualScale)})).isSameAs((Object)Float.valueOf(scale));
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=16)
    public S hasScrollBarDefaultDelayBeforeFade(int fade) {
        this.isNotNull();
        int actualFade = ((View)this.actual).getScrollBarDefaultDelayBeforeFade();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualFade).overridingErrorMessage("Expected scroll bar default delay before fade <%s> but was <%s>", new Object[]{fade, actualFade})).isEqualTo(fade);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=16)
    public S hasScrollBarFadeDuration(int fade) {
        this.isNotNull();
        int actualFade = ((View)this.actual).getScrollBarFadeDuration();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualFade).overridingErrorMessage("Expected scroll bar fade duration <%s> but was <%s>", new Object[]{fade, actualFade})).isEqualTo(fade);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=16)
    public S hasScrollBarSize(int size) {
        this.isNotNull();
        int actualSize = ((View)this.actual).getScrollBarSize();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualSize).overridingErrorMessage("Expected scroll bar size <%s> but was <%s>", new Object[]{size, actualSize})).isEqualTo(size);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasScrollBarStyle(int style) {
        this.isNotNull();
        int actualStyle = ((View)this.actual).getScrollBarStyle();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualStyle).overridingErrorMessage("Expected scroll bar style <%s> but was <%s>", new Object[]{AbstractViewAssert.scrollBarStyleToString(style), AbstractViewAssert.scrollBarStyleToString(actualStyle)})).isEqualTo(style);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasScrollX(int scroll) {
        this.isNotNull();
        int actualScroll = ((View)this.actual).getScrollX();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualScroll).overridingErrorMessage("Expected x scroll <%s> but was <%s>", new Object[]{scroll, actualScroll})).isEqualTo(scroll);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasScrollY(int scroll) {
        this.isNotNull();
        int actualScroll = ((View)this.actual).getScrollY();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualScroll).overridingErrorMessage("Expected y scroll <%s> but was <%s>", new Object[]{scroll, actualScroll})).isEqualTo(scroll);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasSolidColor(int color) {
        this.isNotNull();
        int actualColor = ((View)this.actual).getSolidColor();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualColor).overridingErrorMessage("Expected solid color <%s> but was <%s>", new Object[]{Integer.toHexString(color), Integer.toHexString(actualColor)})).isEqualTo(color);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=11)
    public S hasSystemUiVisibility(int visibility) {
        this.isNotNull();
        int actualVisibility = ((View)this.actual).getSystemUiVisibility();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualVisibility).overridingErrorMessage("Expected system UI visibility <%s> but was <%s>", new Object[]{visibility, actualVisibility})).isEqualTo(visibility);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasTag(int key, Object tag) {
        this.isNotNull();
        Object actualTag = ((View)this.actual).getTag(key);
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualTag).overridingErrorMessage("Expected tag <%s> at key %s but was <%s>", new Object[]{tag, key, actualTag})).isSameAs(tag);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasTag(Object tag) {
        this.isNotNull();
        Object actualTag = ((View)this.actual).getTag();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualTag).overridingErrorMessage("Expected tag <%s> but was <%s>", new Object[]{tag, actualTag})).isSameAs(tag);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=17)
    public S hasTextAlignment(int alignment) {
        this.isNotNull();
        int actualAlignment = ((View)this.actual).getTextAlignment();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualAlignment).overridingErrorMessage("Expected text alignment <%s> but was <%s>", new Object[]{AbstractViewAssert.textAlignmentToString(alignment), AbstractViewAssert.textAlignmentToString(actualAlignment)})).isEqualTo(alignment);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=17)
    public S hasTextDirection(int direction) {
        this.isNotNull();
        int actualDirection = ((View)this.actual).getTextDirection();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualDirection).overridingErrorMessage("Expected text direction <%s> but was <%s>", new Object[]{AbstractViewAssert.textDirectionToString(direction), AbstractViewAssert.textDirectionToString(actualDirection)})).isEqualTo(direction);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasTop(int top) {
        this.isNotNull();
        int actualTop = ((View)this.actual).getTop();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualTop).overridingErrorMessage("Expected top <%s> but was <%s>", new Object[]{top, actualTop})).isEqualTo(top);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=11)
    public S hasTranslationX(float translation) {
        this.isNotNull();
        float actualTranslation = ((View)this.actual).getTranslationX();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualTranslation).overridingErrorMessage("Expected x translation <%s> but was <%s>", new Object[]{Float.valueOf(translation), Float.valueOf(actualTranslation)})).isEqualTo(translation);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=11)
    public S hasTranslationY(float translation) {
        this.isNotNull();
        float actualTranslation = ((View)this.actual).getTranslationY();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualTranslation).overridingErrorMessage("Expected y translation <%s> but was <%s>", new Object[]{Float.valueOf(translation), Float.valueOf(actualTranslation)})).isEqualTo(translation);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasVerticalFadingEdgeLength(int length) {
        this.isNotNull();
        int actualLength = ((View)this.actual).getVerticalFadingEdgeLength();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualLength).overridingErrorMessage("Expected vertical fading edge length <%s> but was <%s>", new Object[]{length, actualLength})).isEqualTo(length);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=11)
    public S hasVerticalScrollbarPosition(int position) {
        this.isNotNull();
        int actualPosition = ((View)this.actual).getVerticalScrollbarPosition();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPosition).overridingErrorMessage("Expected vertical scroll bar position <%s> but was <%s>", new Object[]{AbstractViewAssert.verticalScrollBarPositionToString(position), AbstractViewAssert.verticalScrollBarPositionToString(actualPosition)})).isEqualTo(position);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasVerticalScrollbarWidth(int width) {
        this.isNotNull();
        int actualWidth = ((View)this.actual).getVerticalScrollbarWidth();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected vertical scroll bar width <%s> but was <%s>", new Object[]{width, actualWidth})).isEqualTo(width);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasVisibility(int visibility) {
        this.isNotNull();
        int actualVisibility = ((View)this.actual).getVisibility();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualVisibility).overridingErrorMessage("Expected visibility <%s> but was <%s>.", new Object[]{AbstractViewAssert.visibilityToString(visibility), AbstractViewAssert.visibilityToString(actualVisibility)})).isEqualTo(visibility);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isVisible() {
        this.isNotNull();
        int actualVisibility = ((View)this.actual).getVisibility();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualVisibility).overridingErrorMessage("Expected to be visible but was %s", new Object[]{AbstractViewAssert.visibilityToString(actualVisibility)})).isEqualTo(0);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotVisible() {
        this.isNotNull();
        int actualVisibility = ((View)this.actual).getVisibility();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualVisibility).overridingErrorMessage("Expected to be not visible but was visible", new Object[0])).isNotEqualTo(0);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isInvisible() {
        this.isNotNull();
        int actualVisibility = ((View)this.actual).getVisibility();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualVisibility).overridingErrorMessage("Expected to be invisible but was %s", new Object[]{AbstractViewAssert.visibilityToString(actualVisibility)})).isEqualTo(4);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotInvisible() {
        this.isNotNull();
        int actualVisibility = ((View)this.actual).getVisibility();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualVisibility).overridingErrorMessage("Expected to be not invisible but was invisible", new Object[0])).isNotEqualTo(4);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isGone() {
        this.isNotNull();
        int actualVisibility = ((View)this.actual).getVisibility();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualVisibility).overridingErrorMessage("Expected to be gone but was %s", new Object[]{AbstractViewAssert.visibilityToString(actualVisibility)})).isEqualTo(8);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotGone() {
        this.isNotNull();
        int actualVisibility = ((View)this.actual).getVisibility();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualVisibility).overridingErrorMessage("Expected to be not gone but was gone", new Object[0])).isNotEqualTo(8);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasWidth(int width) {
        this.isNotNull();
        int actualWidth = ((View)this.actual).getWidth();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected width <%s> but was <%s>", new Object[]{width, actualWidth})).isEqualTo(width);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasWindowVisibility(int visibility) {
        this.isNotNull();
        int actualVisibility = ((View)this.actual).getWindowVisibility();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualVisibility).overridingErrorMessage("Expected window visibility <%s> but was <%s>", new Object[]{AbstractViewAssert.visibilityToString(visibility), AbstractViewAssert.visibilityToString(actualVisibility)})).isEqualTo(visibility);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=11)
    public S hasX(float x) {
        this.isNotNull();
        float actualX = ((View)this.actual).getX();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualX).overridingErrorMessage("Expected x <%s> but was <%s>", new Object[]{Float.valueOf(x), Float.valueOf(actualX)})).isEqualTo(x);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=11)
    public S hasY(float y) {
        this.isNotNull();
        float actualY = ((View)this.actual).getY();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualY).overridingErrorMessage("Expected y <%s> but was <%s>", new Object[]{Float.valueOf(y), Float.valueOf(actualY)})).isEqualTo(y);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasFocus() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).hasFocus()).overridingErrorMessage("Expected to have focus but was not focused", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasNoFocus() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).hasFocus()).overridingErrorMessage("Expected to not have focus but was focused", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasFocusable() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).hasFocusable()).overridingErrorMessage("Expected to have focusable but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isInFocusedWindow() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).hasWindowFocus()).overridingErrorMessage("Expected to be in a focused window but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotInFocusedWindow() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).hasWindowFocus()).overridingErrorMessage("Expected to not be in a focused window but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=11)
    public S isActivated() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isActivated()).overridingErrorMessage("Expected to be activated but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=11)
    public S isNotActivated() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isActivated()).overridingErrorMessage("Expected to not be activated but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isClickable() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isClickable()).overridingErrorMessage("Expected to be clickable but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotClickable() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isClickable()).overridingErrorMessage("Expected to not be clickable but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=11)
    public S isDirty() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isDirty()).overridingErrorMessage("Expected to be dirty but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=11)
    public S isNotDirty() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isDirty()).overridingErrorMessage("Expected to not be dirty but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isUsingDrawingCache() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isDrawingCacheEnabled()).overridingErrorMessage("Expected to use drawing cache but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotUsingDrawingCache() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isDrawingCacheEnabled()).overridingErrorMessage("Expected to not be using drawing cache but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isDuplicatingParentState() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isDuplicateParentStateEnabled()).overridingErrorMessage("Expected to be duplicating parent state but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotDuplicatingParentState() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isDuplicateParentStateEnabled()).overridingErrorMessage("Expected to not be duplicated parent state but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isEnabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isEnabled()).overridingErrorMessage("Expected to be enabled but was disabled", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isDisabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isEnabled()).overridingErrorMessage("Expected to be disabled but was enabled", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isFocusable() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isFocusable()).overridingErrorMessage("Expected to be focusable but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotFocusable() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isFocusable()).overridingErrorMessage("Expected to not be focusable but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isFocusableInTouchMode() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isFocusableInTouchMode()).overridingErrorMessage("Expected to be focusable in touch mode but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotFocusableInTouchMode() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isFocusableInTouchMode()).overridingErrorMessage("Expected to not be focusable in touch mode but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isFocused() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isFocused()).overridingErrorMessage("Expected to be focused but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotFocused() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isFocused()).overridingErrorMessage("Expected to not be focused but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasHapticFeedbackEnabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isHapticFeedbackEnabled()).overridingErrorMessage("Expected to have haptic feedback enabled but was disabled", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasHapticFeedbackDisabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isHapticFeedbackEnabled()).overridingErrorMessage("Expected to have haptic feedback disabled but was enabled", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=11)
    public S isHardwareAccelerated() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isHardwareAccelerated()).overridingErrorMessage("Expected to be hardware accelerated but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=11)
    public S isNotHardwareAccelerated() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isHardwareAccelerated()).overridingErrorMessage("Expected to not be hardware accelerated but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasHorizontalFadingEdgesEnabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isHorizontalFadingEdgeEnabled()).overridingErrorMessage("Expected to be fading horizontal edges but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasHorizontalFadingEdgesDisabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isHorizontalFadingEdgeEnabled()).overridingErrorMessage("Expected to not be fading horizontal edges but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasHorizontalScrollbarEnabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isHorizontalScrollBarEnabled()).overridingErrorMessage("Expected to have horizontal scroll bar enabled but was disabled", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasHorizontalScrollbarDisabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isHorizontalScrollBarEnabled()).overridingErrorMessage("Expected to have horizontal scroll bar disabled but was enabled", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=14)
    public S isHovered() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isHovered()).overridingErrorMessage("Expected to be hovered but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=14)
    public S isNotHovered() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isHovered()).overridingErrorMessage("Expected to not be hoevered but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isInEditMode() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isInEditMode()).overridingErrorMessage("Expected to be in edit mode but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotInEditMode() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isInEditMode()).overridingErrorMessage("Expected to not be in edit mode but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=18)
    public S isInLayout() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isInLayout()).overridingErrorMessage("Expected to be in layout but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=18)
    public S isNotInLayout() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isInLayout()).overridingErrorMessage("Expect to not be in layout but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isInTouchMode() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isInTouchMode()).overridingErrorMessage("Expected to be in touch mode but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotInTouchMode() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isInTouchMode()).overridingErrorMessage("Expected to not be in touch mode but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasLayoutRequested() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isLayoutRequested()).overridingErrorMessage("Expected to have layout requested but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasNoLayoutRequested() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isLayoutRequested()).overridingErrorMessage("Expected to not have layout requested but had", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isLongClickable() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isLongClickable()).overridingErrorMessage("Expected to be long-clickable but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotLongClickable() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isLongClickable()).overridingErrorMessage("Expected to not be long-clickable but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isOpaque() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isOpaque()).overridingErrorMessage("Expected to be opaque but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotOpaque() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isOpaque()).overridingErrorMessage("Expected to not be opaque but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isPressed() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isPressed()).overridingErrorMessage("Expected to be pressed but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotPressed() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isPressed()).overridingErrorMessage("Expected to not be pressed but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasSaveEnabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isSaveEnabled()).overridingErrorMessage("Expected to have save enabled but was disabled", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasSaveDisabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isSaveEnabled()).overridingErrorMessage("Expected to have save disabled but was enabled", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=11)
    public S hasSaveFromParentEnabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isSaveFromParentEnabled()).overridingErrorMessage("Expected to have save from parent enabled but was disabled", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=11)
    public S hasSaveFromParentDisabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isSaveFromParentEnabled()).overridingErrorMessage("Expected to have save from parent disabled but was enabled", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=16)
    public S isScrollContainer() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isScrollContainer()).overridingErrorMessage("Expected to be a scroll container but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=16)
    public S isNotScrollContainer() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isScrollContainer()).overridingErrorMessage("Expected to not be a scroll container but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasScrollbarFadingEnabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isScrollbarFadingEnabled()).overridingErrorMessage("Expected to have scroll bar fading enabled but was disabled", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasScrollbarFadingDisabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isScrollbarFadingEnabled()).overridingErrorMessage("Expected to have scroll bar fading disabled but was enabled", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isSelected() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isSelected()).overridingErrorMessage("Expected to be selected but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotSelected() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isSelected()).overridingErrorMessage("Expected to not be selected but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isShown() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isShown()).overridingErrorMessage("Expected to be shown but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotShown() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isShown()).overridingErrorMessage("Expected to not be shown but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasSoundEffectsEnabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isSoundEffectsEnabled()).overridingErrorMessage("Expected sound effects to be enabled but was disabled", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasSoundEffectsDisabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isSoundEffectsEnabled()).overridingErrorMessage("Expected sound effects to be disabled but was enabled", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasVerticalFadingEdgeEnabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isVerticalFadingEdgeEnabled()).overridingErrorMessage("Expected to have vertical fading edge enabled but was disabled", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasVerticalFadingEdgeDisabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isVerticalFadingEdgeEnabled()).overridingErrorMessage("Expected to have vertical fading edge disabled but was enabled", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasVerticalScrollBarEnabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isVerticalScrollBarEnabled()).overridingErrorMessage("Expected to have vertical scroll bar enabled but was disabled", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasVerticalScrollBarDisabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isVerticalScrollBarEnabled()).overridingErrorMessage("Expected to have vertical scroll bar disabled but was enabled", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=19)
    public S canResolveLayoutDirection() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).canResolveLayoutDirection()).overridingErrorMessage("Expected to be able to resolve layout direction but cannot.", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=19)
    public S canNotResolveLayoutDirection() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).canResolveLayoutDirection()).overridingErrorMessage("Expected to not be able to resolve layout direction but can.", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=19)
    public S canResolveTextAlignment() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).canResolveLayoutDirection()).overridingErrorMessage("Expected to  be able to resolve text alignment but cannot.", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=19)
    public S canNotResolveTextAlignment() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).canResolveLayoutDirection()).overridingErrorMessage("Expected to not be able to resolve text alignment but can.", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=19)
    public S canResolveTextDirection() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).canResolveTextDirection()).overridingErrorMessage("Expected to be able to resolve text direction but cannot.", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=19)
    public S canNotResolveTextDirection() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).canResolveTextDirection()).overridingErrorMessage("Expected to not be able to resolve text direction but can.", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=19)
    public S isAttachedToWindow() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isAttachedToWindow()).overridingErrorMessage("Expected to be attached to window but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=19)
    public S isNotAttachedToWindow() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isAttachedToWindow()).overridingErrorMessage("Expected to be not attached to window but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=19)
    public S isLaidOut() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isLaidOut()).overridingErrorMessage("Expected to be laid out but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=19)
    public S isNotLaidOut() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isLaidOut()).overridingErrorMessage("Expected to be not laid out but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=19)
    public S hasResolvedLayoutDirection() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isLayoutDirectionResolved()).overridingErrorMessage("Expected layout direction to be resolved but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=19)
    public S hasNotResolvedLayoutDirection() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isLayoutDirectionResolved()).overridingErrorMessage("Expected layout direction to not be resolved but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=19)
    public S hasResolvedTextAlignment() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isTextAlignmentResolved()).overridingErrorMessage("Expected text alignment to be resolved but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=19)
    public S hasNotResolvedTextAlignment() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isTextAlignmentResolved()).overridingErrorMessage("Expected text alignment to not be resolved but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=19)
    public S hasResolvedTextDirection() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isTextDirectionResolved()).overridingErrorMessage("Expected text direction to be resolved but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    @TargetApi(value=19)
    public S hasNotResolvedTextDirection() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isTextDirectionResolved()).overridingErrorMessage("Expected text direction to not be resolved but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public static String visibilityToString(int visibility) {
        return IntegerUtils.buildNamedValueString(visibility).value(0, "visible").value(4, "invisible").value(8, "gone").get();
    }

    @TargetApi(value=11)
    public static String layerTypeToString(int type) {
        return IntegerUtils.buildNamedValueString(type).value(0, "none").value(1, "software").value(2, "hardware").get();
    }

    @TargetApi(value=17)
    public static String layoutDirectionToString(int direction) {
        return IntegerUtils.buildNamedValueString(direction).value(1, "right_to_left").value(0, "left_to_right").value(2, "inherit").value(3, "locale").get();
    }

    @TargetApi(value=9)
    public static String overScrollModeToString(int mode) {
        return IntegerUtils.buildNamedValueString(mode).value(0, "always").value(1, "ifContentScrolls").value(2, "never").get();
    }

    public static String scrollBarStyleToString(int style) {
        return IntegerUtils.buildNamedValueString(style).value(0x1000000, "insideInset").value(0, "insideOverlay").value(0x3000000, "outsideInset").value(0x2000000, "outsideOverlay").get();
    }

    @TargetApi(value=11)
    public static String verticalScrollBarPositionToString(int position) {
        return IntegerUtils.buildNamedValueString(position).value(0, "default").value(1, "left").value(2, "right").get();
    }

    public static String textAlignmentToString(int alignment) {
        return IntegerUtils.buildNamedValueString(alignment).value(0, "inherit").value(1, "gravity").value(2, "text_start").value(3, "text_end").value(4, "center").value(5, "view_start").value(6, "view_end").get();
    }

    public static String textDirectionToString(int direction) {
        return IntegerUtils.buildNamedValueString(direction).value(0, "inherit").value(1, "first_strong").value(2, "any_right_to_left").value(3, "left_to_right").value(4, "right_to_left").value(5, "locale").get();
    }
}

