/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.view;

import android.annotation.TargetApi;
import android.view.InputEvent;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;

@TargetApi(value=9)
public abstract class AbstractInputEventAssert<S extends AbstractInputEventAssert<S, A>, A extends InputEvent>
extends AbstractAssert<S, A> {
    protected AbstractInputEventAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasDeviceId(int id) {
        this.isNotNull();
        int actualId = ((InputEvent)this.actual).getDeviceId();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected device ID <%s> but was <%s>", new Object[]{id, actualId})).isEqualTo(id);
        return (S)((Object)((AbstractInputEventAssert)this.myself));
    }

    @TargetApi(value=16)
    public S hasEventTime(long time) {
        this.isNotNull();
        long actualTime = ((InputEvent)this.actual).getEventTime();
        ((AbstractLongAssert)Assertions.assertThat((long)actualTime).overridingErrorMessage("Expected time <%s> but was <%s>", new Object[]{time, actualTime})).isEqualTo(time);
        return (S)((Object)((AbstractInputEventAssert)this.myself));
    }

    public S hasSource(int source) {
        this.isNotNull();
        int actualSource = ((InputEvent)this.actual).getSource();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualSource).overridingErrorMessage("Expected source <%s> but was <%s>", new Object[]{source, actualSource})).isEqualTo(source);
        return (S)((Object)((AbstractInputEventAssert)this.myself));
    }
}

