/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.util;

import android.util.SparseArray;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class SparseArrayAssert<E>
extends AbstractAssert<SparseArrayAssert<E>, SparseArray<E>> {
    public SparseArrayAssert(SparseArray<E> actual) {
        super(actual, SparseArrayAssert.class);
    }

    public SparseArrayAssert<E> hasKey(int key) {
        this.isNotNull();
        ((AbstractIntegerAssert)Assertions.assertThat((int)((SparseArray)this.actual).indexOfKey(key)).overridingErrorMessage("Expected key <%s> to be present but was not.", new Object[]{key})).isGreaterThanOrEqualTo(0);
        return this;
    }

    public SparseArrayAssert<E> doesNotHaveKey(int key) {
        this.isNotNull();
        ((AbstractIntegerAssert)Assertions.assertThat((int)((SparseArray)this.actual).indexOfKey(key)).overridingErrorMessage("Expected key <%s> to not be present but was.", new Object[0])).isLessThan(0);
        return this;
    }

    public SparseArrayAssert<E> hasSize(int size) {
        this.isNotNull();
        int actualSize = ((SparseArray)this.actual).size();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualSize).overridingErrorMessage("Expected size <%s> but was <%s>.", new Object[]{size, actualSize})).isEqualTo(size);
        return this;
    }
}

