/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.util;

import android.annotation.TargetApi;
import android.util.Property;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractClassAssert;
import org.assertj.core.api.Assertions;

@TargetApi(value=14)
public class PropertyAssert<T, V>
extends AbstractAssert<PropertyAssert<T, V>, Property<T, V>> {
    public PropertyAssert(Property<T, V> actual) {
        super(actual, PropertyAssert.class);
    }

    public PropertyAssert<T, V> hasName(String name) {
        this.isNotNull();
        String actualName = ((Property)this.actual).getName();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualName).overridingErrorMessage("Expected name <%s> but was <%s>", new Object[]{name, actualName})).isEqualTo((Object)name);
        return this;
    }

    public PropertyAssert<T, V> hasType(Class<?> type) {
        this.isNotNull();
        Class actualType = ((Property)this.actual).getType();
        ((AbstractClassAssert)Assertions.assertThat((Class)actualType).overridingErrorMessage("Expected type <%s> but was <%s>", new Object[]{type, actualType})).isEqualTo(type);
        return this;
    }

    public PropertyAssert<T, V> isReadOnly() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Property)this.actual).isReadOnly()).overridingErrorMessage("Expected read only but was not read only.", new Object[0])).isTrue();
        return this;
    }

    public PropertyAssert<T, V> isNotReadOnly() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Property)this.actual).isReadOnly()).overridingErrorMessage("Expected not read only but was read only.", new Object[0])).isFalse();
        return this;
    }
}

