/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.telephony;

import android.telephony.SmsMessage;
import java.util.Arrays;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;

public class SmsMessageAssert
extends AbstractAssert<SmsMessageAssert, SmsMessage> {
    public SmsMessageAssert(SmsMessage actual) {
        super((Object)actual, SmsMessageAssert.class);
    }

    public SmsMessageAssert hasDisplayMessageBody(String displayMessageBody) {
        this.isNotNull();
        String actualDisplayMessageBody = ((SmsMessage)this.actual).getDisplayMessageBody();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualDisplayMessageBody).overridingErrorMessage("Expected display message body <%s> but was <%s>.", new Object[]{displayMessageBody, actualDisplayMessageBody})).isEqualTo((Object)displayMessageBody);
        return this;
    }

    public SmsMessageAssert hasDisplayOriginatingAddress(String displayOriginatingAddress) {
        this.isNotNull();
        String actualDisplayOriginatingAddress = ((SmsMessage)this.actual).getDisplayOriginatingAddress();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualDisplayOriginatingAddress).overridingErrorMessage("Expected display originating address <%s> but was <%s>.", new Object[]{displayOriginatingAddress, actualDisplayOriginatingAddress})).isEqualTo((Object)displayOriginatingAddress);
        return this;
    }

    public SmsMessageAssert hasEmailBody(String emailBody) {
        this.isNotNull();
        String actualEmailBody = ((SmsMessage)this.actual).getEmailBody();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualEmailBody).overridingErrorMessage("Expected email body <%s> but was <%s>.", new Object[]{emailBody, actualEmailBody})).isEqualTo((Object)emailBody);
        return this;
    }

    public SmsMessageAssert hasEmailFrom(String emailFrom) {
        this.isNotNull();
        String actualEmailFrom = ((SmsMessage)this.actual).getEmailFrom();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualEmailFrom).overridingErrorMessage("Expected email from <%s> but was <%s>.", new Object[]{emailFrom, actualEmailFrom})).isEqualTo((Object)emailFrom);
        return this;
    }

    public SmsMessageAssert hasIndexOnIcc(int index) {
        this.isNotNull();
        int actualIndex = ((SmsMessage)this.actual).getIndexOnIcc();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualIndex).overridingErrorMessage("Expected index on ICC <%s> but was <%s>.", new Object[]{index, actualIndex})).isEqualTo(index);
        return this;
    }

    public SmsMessageAssert hasIndexOnSim(int index) {
        this.isNotNull();
        int actualIndex = ((SmsMessage)this.actual).getIndexOnSim();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualIndex).overridingErrorMessage("Expected index on SIM <%s> but was <%s>.", new Object[]{index, actualIndex})).isEqualTo(index);
        return this;
    }

    public SmsMessageAssert hasMessageBody(String messageBody) {
        this.isNotNull();
        String actualMessageBody = ((SmsMessage)this.actual).getMessageBody();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualMessageBody).overridingErrorMessage("Expected message body <%s> but was <%s>.", new Object[]{messageBody, actualMessageBody})).isEqualTo((Object)messageBody);
        return this;
    }

    public SmsMessageAssert hasMessageClass(SmsMessage.MessageClass messageClass) {
        this.isNotNull();
        SmsMessage.MessageClass actualMessageClass = ((SmsMessage)this.actual).getMessageClass();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)actualMessageClass).overridingErrorMessage("Expected message class <%s> but was <%s>.", new Object[]{messageClass, actualMessageClass})).isEqualTo((Object)messageClass);
        return this;
    }

    public SmsMessageAssert hasOriginatingAddress(String originatingAddress) {
        this.isNotNull();
        String actualOriginatingAddress = ((SmsMessage)this.actual).getOriginatingAddress();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualOriginatingAddress).overridingErrorMessage("Expected originating address <%s> but was <%s>.", new Object[]{originatingAddress, actualOriginatingAddress})).isEqualTo((Object)originatingAddress);
        return this;
    }

    public SmsMessageAssert hasPdu(byte[] pdu) {
        this.isNotNull();
        byte[] actualPdu = ((SmsMessage)this.actual).getPdu();
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])actualPdu).overridingErrorMessage("Expected PDU <%s> but was <%s>.", new Object[]{Arrays.toString(pdu), Arrays.toString(actualPdu)})).isEqualTo((Object)pdu);
        return this;
    }

    public SmsMessageAssert hasProtocolIdentifier(int protocolIdentifier) {
        this.isNotNull();
        int actualProtocolIdentifier = ((SmsMessage)this.actual).getProtocolIdentifier();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualProtocolIdentifier).overridingErrorMessage("Expected protocol identifier <%s> but was <%s>.", new Object[]{protocolIdentifier, actualProtocolIdentifier})).isEqualTo(protocolIdentifier);
        return this;
    }

    public SmsMessageAssert hasPseudoSubject(String pseudoSubject) {
        this.isNotNull();
        String actualPseudoSubject = ((SmsMessage)this.actual).getPseudoSubject();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualPseudoSubject).overridingErrorMessage("Expected pseudo subject <%s> but was <%s>.", new Object[]{pseudoSubject, actualPseudoSubject})).isEqualTo((Object)pseudoSubject);
        return this;
    }

    public SmsMessageAssert hasServiceCenterAddress(String address) {
        this.isNotNull();
        String actualAddress = ((SmsMessage)this.actual).getServiceCenterAddress();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualAddress).overridingErrorMessage("Expected service center address <%s> but was <%s>.", new Object[]{address, actualAddress})).isEqualTo((Object)address);
        return this;
    }

    public SmsMessageAssert hasStatus(int status) {
        this.isNotNull();
        int actualStatus = ((SmsMessage)this.actual).getStatus();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualStatus).overridingErrorMessage("Expected status <%s> but was <%s>.", new Object[]{status, actualStatus})).isEqualTo(status);
        return this;
    }

    public SmsMessageAssert hasStatusOnIcc(int status) {
        this.isNotNull();
        int actualStatus = ((SmsMessage)this.actual).getStatusOnIcc();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualStatus).overridingErrorMessage("Expected status on the ICC <%s> but was <%s>.", new Object[]{status, actualStatus})).isEqualTo(status);
        return this;
    }

    public SmsMessageAssert hasStatusOnSim(int status) {
        this.isNotNull();
        int actualStatus = ((SmsMessage)this.actual).getStatusOnSim();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualStatus).overridingErrorMessage("Expected status on the SIM <%s> but was <%s>.", new Object[]{status, actualStatus})).isEqualTo(status);
        return this;
    }

    public SmsMessageAssert hasTimestampMillis(long timestamp) {
        this.isNotNull();
        long actualTimestamp = ((SmsMessage)this.actual).getTimestampMillis();
        ((AbstractLongAssert)Assertions.assertThat((long)actualTimestamp).overridingErrorMessage("Expected timestamp in millis <%s> but was <%s>.", new Object[]{timestamp, actualTimestamp})).isEqualTo(timestamp);
        return this;
    }

    public SmsMessageAssert hasUserData(byte[] data) {
        this.isNotNull();
        byte[] actualData = ((SmsMessage)this.actual).getUserData();
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])actualData).overridingErrorMessage("Expected user data <%s> but was <%s>.", new Object[]{Arrays.toString(data), Arrays.toString(actualData)})).isEqualTo((Object)data);
        return this;
    }

    public SmsMessageAssert isCphsMwiMessage() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SmsMessage)this.actual).isCphsMwiMessage()).overridingErrorMessage("Expected to be CPHS MWI message but was not.", new Object[0])).isTrue();
        return this;
    }

    public SmsMessageAssert isEmail() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SmsMessage)this.actual).isEmail()).overridingErrorMessage("Expected to be an email but was not.", new Object[0])).isTrue();
        return this;
    }

    public SmsMessageAssert isMWIClearMessage() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SmsMessage)this.actual).isMWIClearMessage()).overridingErrorMessage("Expected to be MWI clear message but was not.", new Object[0])).isTrue();
        return this;
    }

    public SmsMessageAssert isMWISetMessage() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SmsMessage)this.actual).isMWISetMessage()).overridingErrorMessage("Expected to be MWI set message but was not.", new Object[0])).isTrue();
        return this;
    }

    public SmsMessageAssert isMwiDontStore() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SmsMessage)this.actual).isMwiDontStore()).overridingErrorMessage("Expected to be MWI message that should not be stored but was not.", new Object[0])).isTrue();
        return this;
    }

    public SmsMessageAssert isReplace() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SmsMessage)this.actual).isReplace()).overridingErrorMessage("Expected to be a replace short message but was not.", new Object[0])).isTrue();
        return this;
    }

    public SmsMessageAssert isReplyPathPresent() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SmsMessage)this.actual).isReplyPathPresent()).overridingErrorMessage("Expected 'TP-Reply-Path' bit is set but was not.", new Object[0])).isTrue();
        return this;
    }

    public SmsMessageAssert isStatusReportMessage() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SmsMessage)this.actual).isStatusReportMessage()).overridingErrorMessage("Expected to be a status report message but was not.", new Object[0])).isTrue();
        return this;
    }
}

