/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.telephony;

import android.telephony.SignalStrength;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class SignalStrengthAssert
extends AbstractAssert<SignalStrengthAssert, SignalStrength> {
    public SignalStrengthAssert(SignalStrength actual) {
        super((Object)actual, SignalStrengthAssert.class);
    }

    public SignalStrengthAssert hasCdmaDbm(int dbm) {
        this.isNotNull();
        int actualDbm = ((SignalStrength)this.actual).getCdmaDbm();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualDbm).overridingErrorMessage("Expected CDMA dBm <%s> but was <%s>.", new Object[]{dbm, actualDbm})).isEqualTo(dbm);
        return this;
    }

    public SignalStrengthAssert hasCdmaEcio(int ecio) {
        this.isNotNull();
        int actualEcio = ((SignalStrength)this.actual).getCdmaEcio();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualEcio).overridingErrorMessage("Expected CDMA Ec/Io <%s> but was <%s>.", new Object[]{ecio, actualEcio})).isEqualTo(ecio);
        return this;
    }

    public SignalStrengthAssert hasEvdoDbm(int dbm) {
        this.isNotNull();
        int actualDbm = ((SignalStrength)this.actual).getEvdoDbm();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualDbm).overridingErrorMessage("Expected EVDO dBm <%s> but was <%s>.", new Object[]{dbm, actualDbm})).isEqualTo(dbm);
        return this;
    }

    public SignalStrengthAssert hasEvdoEcio(int ecio) {
        this.isNotNull();
        int actualEcio = ((SignalStrength)this.actual).getEvdoEcio();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualEcio).overridingErrorMessage("Expected EVDO Ec/Io <%s> but was <%s>.", new Object[]{ecio, actualEcio})).isEqualTo(ecio);
        return this;
    }

    public SignalStrengthAssert hasEvdoSnr(int snr) {
        this.isNotNull();
        int actualSnr = ((SignalStrength)this.actual).getEvdoSnr();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualSnr).overridingErrorMessage("Expected EVDO signal to noise ratio <%s> but was <%s>.", new Object[]{snr, actualSnr})).isEqualTo(snr);
        return this;
    }

    public SignalStrengthAssert hasGsmSignalStrength(int signalStrength) {
        this.isNotNull();
        int actualSignalStrength = ((SignalStrength)this.actual).getGsmSignalStrength();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualSignalStrength).overridingErrorMessage("Expected GSM signal strength <%s> but was <%s>.", new Object[]{signalStrength, actualSignalStrength})).isEqualTo(signalStrength);
        return this;
    }

    public SignalStrengthAssert isGsm() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SignalStrength)this.actual).isGsm()).overridingErrorMessage("Expected to be for GSM but was not.", new Object[0])).isTrue();
        return this;
    }

    public SignalStrengthAssert isNotGsm() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SignalStrength)this.actual).isGsm()).overridingErrorMessage("Expected to not be for GSM but was.", new Object[0])).isFalse();
        return this;
    }
}

