/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.telephony;

import android.telephony.ServiceState;
import org.assertj.android.internal.IntegerUtils;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class ServiceStateAssert
extends AbstractAssert<ServiceStateAssert, ServiceState> {
    public ServiceStateAssert(ServiceState actual) {
        super((Object)actual, ServiceStateAssert.class);
    }

    public ServiceStateAssert isManualSelection() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ServiceState)this.actual).getIsManualSelection()).overridingErrorMessage("Expected to have manual selection mode but had automatic.", new Object[0])).isTrue();
        return this;
    }

    public ServiceStateAssert isAutomaticSelection() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ServiceState)this.actual).getIsManualSelection()).overridingErrorMessage("Expected to have automatic selection mode but had manual.", new Object[0])).isFalse();
        return this;
    }

    public ServiceStateAssert hasOperatorAlphaLong(String operatorAlphaLong) {
        this.isNotNull();
        String actualOperatorAlphaLong = ((ServiceState)this.actual).getOperatorAlphaLong();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualOperatorAlphaLong).overridingErrorMessage("Expected operator name in long alphanumeric format <%s> but was <%s>.", new Object[]{operatorAlphaLong, actualOperatorAlphaLong})).isEqualTo((Object)operatorAlphaLong);
        return this;
    }

    public ServiceStateAssert hasOperatorAlphaShort(String operatorAlphaShort) {
        this.isNotNull();
        String actualOperatorAlphaShort = ((ServiceState)this.actual).getOperatorAlphaShort();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualOperatorAlphaShort).overridingErrorMessage("Expected operator name in short alphanumeric format <%s> but was <%s>.", new Object[]{operatorAlphaShort, actualOperatorAlphaShort})).isEqualTo((Object)operatorAlphaShort);
        return this;
    }

    public ServiceStateAssert hasOperatorNumeric(String operatorNumeric) {
        this.isNotNull();
        String actualOperatorNumeric = ((ServiceState)this.actual).getOperatorNumeric();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualOperatorNumeric).overridingErrorMessage("Expected operator numeric ID <%s> but was <%s>.", new Object[]{operatorNumeric, actualOperatorNumeric})).isEqualTo((Object)operatorNumeric);
        return this;
    }

    public ServiceStateAssert isRoaming() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ServiceState)this.actual).getRoaming()).overridingErrorMessage("Expected to be in roaming but was not.", new Object[0])).isTrue();
        return this;
    }

    public ServiceStateAssert isNotRoaming() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ServiceState)this.actual).getRoaming()).overridingErrorMessage("Expected to not be in roaming but was.", new Object[0])).isFalse();
        return this;
    }

    public ServiceStateAssert hasState(int state) {
        this.isNotNull();
        int actualState = ((ServiceState)this.actual).getState();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualState).overridingErrorMessage("Expected state <%s> but was <%s>.", new Object[]{ServiceStateAssert.serviceStateToString(state), ServiceStateAssert.serviceStateToString(actualState)})).isEqualTo(state);
        return this;
    }

    public static String serviceStateToString(int serviceState) {
        return IntegerUtils.buildNamedValueString(serviceState).value(2, "emergency_only").value(0, "in_service").value(1, "out_of_service").value(3, "power_off").get();
    }
}

