/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.preference;

import android.preference.RingtonePreference;
import org.assertj.android.api.preference.AbstractPreferenceAssert;
import org.assertj.android.internal.IntegerUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class RingtonePreferenceAssert
extends AbstractPreferenceAssert<RingtonePreferenceAssert, RingtonePreference> {
    public RingtonePreferenceAssert(RingtonePreference actual) {
        super(actual, RingtonePreferenceAssert.class);
    }

    public RingtonePreferenceAssert hasRingtoneType(int type) {
        this.isNotNull();
        int actualType = ((RingtonePreference)this.actual).getRingtoneType();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualType).overridingErrorMessage("Expected ringtone type <%s> but was <%s>.", new Object[]{RingtonePreferenceAssert.ringtoneTypeToString(type), RingtonePreferenceAssert.ringtoneTypeToString(actualType)})).isEqualTo(type);
        return this;
    }

    public RingtonePreferenceAssert isShowingDefault() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((RingtonePreference)this.actual).getShowDefault()).overridingErrorMessage("Expected to be showing default but was not.", new Object[0])).isTrue();
        return this;
    }

    public RingtonePreferenceAssert isNotShowingDefault() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((RingtonePreference)this.actual).getShowDefault()).overridingErrorMessage("Expected to not be showing default but was.", new Object[0])).isFalse();
        return this;
    }

    public RingtonePreferenceAssert isShowingSilent() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((RingtonePreference)this.actual).getShowSilent()).overridingErrorMessage("Expected to be showing silent but was not.", new Object[0])).isTrue();
        return this;
    }

    public RingtonePreferenceAssert isNotShowingSilent() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((RingtonePreference)this.actual).getShowSilent()).overridingErrorMessage("Expected to not be showing silent but was.", new Object[0])).isFalse();
        return this;
    }

    private static String ringtoneTypeToString(int type) {
        return IntegerUtils.buildBitMaskString(type).flag(4, "alarm").flag(2, "notification").flag(1, "ringtone").get();
    }
}

