/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.preference;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.drawable.Drawable;
import android.preference.Preference;
import android.preference.PreferenceManager;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

public abstract class AbstractPreferenceAssert<S extends AbstractPreferenceAssert<S, A>, A extends Preference>
extends AbstractAssert<S, A> {
    protected AbstractPreferenceAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasContext(Context context) {
        this.isNotNull();
        Context actualContext = ((Preference)this.actual).getContext();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualContext).overridingErrorMessage("Expected context <%s> but was <%s>.", new Object[]{context, actualContext})).isSameAs((Object)context);
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S hasDependency(String dependency) {
        this.isNotNull();
        String actualDependency = ((Preference)this.actual).getDependency();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualDependency).overridingErrorMessage("Expected dependency <%s> but was <%s>.", new Object[]{dependency, actualDependency})).isEqualTo((Object)dependency);
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    @TargetApi(value=11)
    public S hasFragment(String fragment) {
        this.isNotNull();
        String actualFragment = ((Preference)this.actual).getFragment();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualFragment).overridingErrorMessage("Expected fragment <%s> but was <%s>.", new Object[]{fragment, actualFragment})).isEqualTo((Object)fragment);
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    @TargetApi(value=11)
    public S hasIcon(Drawable icon) {
        this.isNotNull();
        Drawable actualIcon = ((Preference)this.actual).getIcon();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualIcon).overridingErrorMessage("Expected icon <%s> but was <%s>.", new Object[]{icon, actualIcon})).isSameAs((Object)icon);
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S hasIntent(Intent intent) {
        this.isNotNull();
        Intent actualIntent = ((Preference)this.actual).getIntent();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualIntent).overridingErrorMessage("Expected intent <%s> but was <%s>.", new Object[]{intent, actualIntent})).isEqualTo((Object)intent);
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S hasKey(String key) {
        this.isNotNull();
        String actualKey = ((Preference)this.actual).getKey();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualKey).overridingErrorMessage("Expected key <%s> but was <%s>.", new Object[]{key, actualKey})).isEqualTo((Object)key);
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S hasLayoutResource(int resource) {
        this.isNotNull();
        int actualResource = ((Preference)this.actual).getLayoutResource();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualResource).overridingErrorMessage("Expected layout resource ID <%s> but was <%s>.", new Object[]{resource, actualResource})).isEqualTo(resource);
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S hasPreferenceChangeListener(Preference.OnPreferenceChangeListener listener) {
        this.isNotNull();
        Preference.OnPreferenceChangeListener actualListener = ((Preference)this.actual).getOnPreferenceChangeListener();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualListener).overridingErrorMessage("Expected preference change listener <%s> but was <%s>.", new Object[]{listener, actualListener})).isSameAs((Object)listener);
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S hasPreferenceClickListener(Preference.OnPreferenceClickListener listener) {
        this.isNotNull();
        Preference.OnPreferenceClickListener actualListener = ((Preference)this.actual).getOnPreferenceClickListener();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualListener).overridingErrorMessage("Expected preference click listener <%s> but was <%s>.", new Object[]{listener, actualListener})).isSameAs((Object)listener);
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S hasOrder(int order) {
        this.isNotNull();
        int actualOrder = ((Preference)this.actual).getOrder();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualOrder).overridingErrorMessage("Expected order <%s> but was <%s>.", new Object[]{order, actualOrder})).isEqualTo(order);
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S hasPreferenceManager(PreferenceManager manager) {
        this.isNotNull();
        PreferenceManager actualManager = ((Preference)this.actual).getPreferenceManager();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualManager).overridingErrorMessage("Expected preference manager <%s> but was <%s>.", new Object[]{manager, actualManager})).isSameAs((Object)manager);
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S hasSharedPreferences(SharedPreferences preferences) {
        this.isNotNull();
        SharedPreferences actualPreferences = ((Preference)this.actual).getSharedPreferences();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualPreferences).overridingErrorMessage("Expected shared preferences <%s> but was <%s>.", new Object[]{preferences, actualPreferences})).isSameAs((Object)preferences);
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S hasSummary(CharSequence summary) {
        this.isNotNull();
        CharSequence actualSummary = ((Preference)this.actual).getSummary();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)actualSummary).overridingErrorMessage("Expected summary <%s> but was <%s>.", new Object[]{summary, actualSummary})).isEqualTo((Object)summary);
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S hasSummary(int resId) {
        this.isNotNull();
        return this.hasSummary(((Preference)this.actual).getContext().getString(resId));
    }

    public S hasTitle(CharSequence title) {
        this.isNotNull();
        CharSequence actualTitle = ((Preference)this.actual).getTitle();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)actualTitle).overridingErrorMessage("Expected title <%s> but was <%s>.", new Object[]{title, actualTitle})).isEqualTo((Object)title);
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S hasTitle(int resId) {
        this.isNotNull();
        return this.hasTitle(((Preference)this.actual).getContext().getString(resId));
    }

    @TargetApi(value=14)
    public S hasTitleResource(int resource) {
        this.isNotNull();
        int actualResource = ((Preference)this.actual).getTitleRes();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualResource).overridingErrorMessage("Expected title resource <%s> but was <%s>.", new Object[]{resource, actualResource})).isEqualTo(resource);
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S hasWidgetLayoutResource(int resource) {
        this.isNotNull();
        int actualResource = ((Preference)this.actual).getWidgetLayoutResource();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualResource).overridingErrorMessage("Expected widget layout resource <%s> but was <%s>.", new Object[]{resource, actualResource})).isEqualTo(resource);
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S hasKey() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Preference)this.actual).hasKey()).overridingErrorMessage("Expected to have valid key but was invalid.", new Object[0])).isTrue();
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S isEnabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Preference)this.actual).isEnabled()).overridingErrorMessage("Expected to be enabled but was disabled.", new Object[0])).isTrue();
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S isDisabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Preference)this.actual).isEnabled()).overridingErrorMessage("Expected to be disabled but was enabled.", new Object[0])).isFalse();
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S isPersistent() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Preference)this.actual).isPersistent()).overridingErrorMessage("Expected to be persistent but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S isNotPersistent() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Preference)this.actual).isPersistent()).overridingErrorMessage("Expected to not be persistent but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S isSelectable() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Preference)this.actual).isSelectable()).overridingErrorMessage("Expected to be selectable but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }

    public S isNotSelectable() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Preference)this.actual).isSelectable()).overridingErrorMessage("Expected to not be selectable but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractPreferenceAssert)this.myself));
    }
}

