/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.hardware;

import android.annotation.TargetApi;
import android.hardware.Sensor;
import org.assertj.android.internal.IntegerUtils;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class SensorAssert
extends AbstractAssert<SensorAssert, Sensor> {
    public SensorAssert(Sensor actual) {
        super((Object)actual, SensorAssert.class);
    }

    public SensorAssert hasMaximumRange(float range) {
        this.isNotNull();
        float actualRange = ((Sensor)this.actual).getMaximumRange();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualRange).overridingErrorMessage("Expected maximum range <%s> but was <%s>.", new Object[]{Float.valueOf(range), Float.valueOf(actualRange)})).isEqualTo(range);
        return this;
    }

    @TargetApi(value=9)
    public SensorAssert hasMinDelay(int delay) {
        this.isNotNull();
        int actualDelay = ((Sensor)this.actual).getMinDelay();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualDelay).overridingErrorMessage("Expected minimum delay <%s> but was <%s>.", new Object[]{delay, actualDelay})).isEqualTo(delay);
        return this;
    }

    public SensorAssert hasName(String name) {
        this.isNotNull();
        String actualName = ((Sensor)this.actual).getName();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualName).overridingErrorMessage("Expected name <%s> but was <%s>.", new Object[]{name, actualName})).isEqualTo((Object)name);
        return this;
    }

    public SensorAssert hasPower(float power) {
        this.isNotNull();
        float actualPower = ((Sensor)this.actual).getPower();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualPower).overridingErrorMessage("Expected power <%s> but was <%s>.", new Object[]{Float.valueOf(power), Float.valueOf(actualPower)})).isEqualTo(power);
        return this;
    }

    public SensorAssert hasResolution(float resolution) {
        this.isNotNull();
        float actualResolution = ((Sensor)this.actual).getResolution();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualResolution).overridingErrorMessage("Expected resolution <%s> but was <%s>.", new Object[]{Float.valueOf(resolution), Float.valueOf(actualResolution)})).isEqualTo(resolution);
        return this;
    }

    public SensorAssert hasType(int type) {
        this.isNotNull();
        int actualType = ((Sensor)this.actual).getType();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualType).overridingErrorMessage("Expected type <%s> but was <%s>.", new Object[]{SensorAssert.typeToString(type), SensorAssert.typeToString(actualType)})).isEqualTo(type);
        return this;
    }

    public SensorAssert hasVendor(String vendor) {
        this.isNotNull();
        String actualVendor = ((Sensor)this.actual).getVendor();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualVendor).overridingErrorMessage("Expected vendor <%s> but was <%s>.", new Object[]{vendor, actualVendor})).isEqualTo((Object)vendor);
        return this;
    }

    public SensorAssert hasVersion(int version) {
        this.isNotNull();
        int actualVersion = ((Sensor)this.actual).getVersion();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualVersion).overridingErrorMessage("Expected version <%s> but was <%s>.", new Object[]{version, actualVersion})).isEqualTo(version);
        return this;
    }

    @TargetApi(value=19)
    public SensorAssert hasFifoMaxEventCount(float count) {
        this.isNotNull();
        float actualCount = ((Sensor)this.actual).getFifoMaxEventCount();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualCount).overridingErrorMessage("Expected max event count to be <%s> but was <%s>.", new Object[]{Float.valueOf(count), Float.valueOf(actualCount)})).isEqualTo(count);
        return this;
    }

    @TargetApi(value=19)
    public SensorAssert hasFifoReservedEventCount(float count) {
        this.isNotNull();
        float actualCount = ((Sensor)this.actual).getFifoReservedEventCount();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualCount).overridingErrorMessage("Expected reserved event count to be <%s> but was <%s>.", new Object[]{Float.valueOf(count), Float.valueOf(actualCount)})).isEqualTo(count);
        return this;
    }

    public static String typeToString(int type) {
        return IntegerUtils.buildNamedValueString(type).value(1, "accelerometer").value(-1, "all").value(13, "ambient_temperature").value(15, "game_rotation_vector").value(20, "geomagnetic_rotation_vector").value(9, "gravity").value(4, "gyroscope").value(16, "gyroscope_uncalibrated").value(21, "heart_rate").value(5, "light").value(10, "linear_acceleration").value(2, "magnetic_field").value(14, "magnetic_field_uncalibrated").value(3, "orientation").value(6, "pressure").value(8, "proximity").value(12, "relative_humidity").value(11, "rotation_vector").value(17, "significant_motion").value(19, "step_counter").value(18, "step_detector").value(7, "temperature").get();
    }
}

