/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.graphics;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.NinePatch;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

public class NinePatchAssert
extends AbstractAssert<NinePatchAssert, NinePatch> {
    public NinePatchAssert(NinePatch actual) {
        super((Object)actual, NinePatchAssert.class);
    }

    public NinePatchAssert hasDensity(int density) {
        this.isNotNull();
        int actualHeight = ((NinePatch)this.actual).getDensity();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected density <%s> but was <%s>.", new Object[]{density, actualHeight})).isEqualTo(density);
        return this;
    }

    public NinePatchAssert hasHeight(int height) {
        this.isNotNull();
        int actualHeight = ((NinePatch)this.actual).getHeight();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected height <%s> but was <%s>.", new Object[]{height, actualHeight})).isEqualTo(height);
        return this;
    }

    public NinePatchAssert hasWidth(int width) {
        this.isNotNull();
        int actualHeight = ((NinePatch)this.actual).getWidth();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected width <%s> but was <%s>.", new Object[]{width, actualHeight})).isEqualTo(width);
        return this;
    }

    public NinePatchAssert hasAlpha() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((NinePatch)this.actual).hasAlpha()).overridingErrorMessage("Expected to have alpha but did not.", new Object[0])).isTrue();
        return this;
    }

    public NinePatchAssert hasNoAlpha() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((NinePatch)this.actual).hasAlpha()).overridingErrorMessage("Expected to not have alpha but did.", new Object[0])).isFalse();
        return this;
    }

    @TargetApi(value=19)
    public NinePatchAssert hasName(String name) {
        this.isNotNull();
        String actualName = ((NinePatch)this.actual).getName();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualName).overridingErrorMessage("Expected name to be <%s> but was <%s>.", new Object[]{name, actualName})).isEqualTo((Object)name);
        return this;
    }

    @TargetApi(value=19)
    public NinePatchAssert hasBitmap(Bitmap bitmap) {
        this.isNotNull();
        Bitmap actualBitmap = ((NinePatch)this.actual).getBitmap();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualBitmap).overridingErrorMessage("Expected bitmap <%s> but was <%s>.", new Object[]{bitmap, actualBitmap})).isEqualTo((Object)bitmap);
        return this;
    }
}

