/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.database.sqlite;

import android.annotation.TargetApi;
import android.database.sqlite.SQLiteDatabase;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;

public class SqliteDatabaseAssert
extends AbstractAssert<SqliteDatabaseAssert, SQLiteDatabase> {
    public SqliteDatabaseAssert(SQLiteDatabase actual) {
        super((Object)actual, SqliteDatabaseAssert.class);
    }

    public SqliteDatabaseAssert hasMaximumSize(long size) {
        this.isNotNull();
        long actualSize = ((SQLiteDatabase)this.actual).getMaximumSize();
        ((AbstractLongAssert)Assertions.assertThat((long)actualSize).overridingErrorMessage("Expected maximum size <%s> but was <%s>.", new Object[]{size, actualSize})).isEqualTo(size);
        return this;
    }

    public SqliteDatabaseAssert hasPageSize(long size) {
        this.isNotNull();
        long actualSize = ((SQLiteDatabase)this.actual).getPageSize();
        ((AbstractLongAssert)Assertions.assertThat((long)actualSize).overridingErrorMessage("Expected page size <%s> but was <%s>.", new Object[]{size, actualSize})).isEqualTo(size);
        return this;
    }

    public SqliteDatabaseAssert hasPath(String path) {
        this.isNotNull();
        String actualPath = ((SQLiteDatabase)this.actual).getPath();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualPath).overridingErrorMessage("Expected path <%s> but was <%s>.", new Object[]{path, actualPath})).isEqualTo((Object)path);
        return this;
    }

    public SqliteDatabaseAssert hasVersion(int version) {
        this.isNotNull();
        int actualVersion = ((SQLiteDatabase)this.actual).getVersion();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualVersion).overridingErrorMessage("Expected version <%s> but was <%s>.", new Object[]{version, actualVersion})).isEqualTo(version);
        return this;
    }

    public SqliteDatabaseAssert isInTransaction() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SQLiteDatabase)this.actual).inTransaction()).overridingErrorMessage("Expected to be in transaction but was not.", new Object[0])).isTrue();
        return this;
    }

    public SqliteDatabaseAssert isNotInTransaction() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SQLiteDatabase)this.actual).inTransaction()).overridingErrorMessage("Expected to not be in transaction but was.", new Object[0])).isFalse();
        return this;
    }

    @TargetApi(value=11)
    public SqliteDatabaseAssert isDatabaseIntegrityOk() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SQLiteDatabase)this.actual).isDatabaseIntegrityOk()).overridingErrorMessage("Expected database integrity to be OK but was not.", new Object[0])).isTrue();
        return this;
    }

    @TargetApi(value=11)
    public SqliteDatabaseAssert isDatabaseIntegrityNotOk() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SQLiteDatabase)this.actual).isDatabaseIntegrityOk()).overridingErrorMessage("Expected database integrity to not be OK but was.", new Object[0])).isFalse();
        return this;
    }

    public SqliteDatabaseAssert isLockedByCurrentThread() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SQLiteDatabase)this.actual).isDbLockedByCurrentThread()).overridingErrorMessage("Expected DB to be locked by current thread but was not.", new Object[0])).isTrue();
        return this;
    }

    public SqliteDatabaseAssert isNotLockedByCurrentThread() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SQLiteDatabase)this.actual).isDbLockedByCurrentThread()).overridingErrorMessage("Expected DB to not be locked but current thread but was.", new Object[0])).isFalse();
        return this;
    }

    public SqliteDatabaseAssert isOpen() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SQLiteDatabase)this.actual).isOpen()).overridingErrorMessage("Expected DB to be open but was not.", new Object[0])).isTrue();
        return this;
    }

    public SqliteDatabaseAssert isNotOpen() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SQLiteDatabase)this.actual).isOpen()).overridingErrorMessage("Expected DB to not be open but was.", new Object[0])).isFalse();
        return this;
    }

    public SqliteDatabaseAssert isReadOnly() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SQLiteDatabase)this.actual).isReadOnly()).overridingErrorMessage("Expected DB to be read only but was not.", new Object[0])).isTrue();
        return this;
    }

    public SqliteDatabaseAssert isNotReadOnly() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SQLiteDatabase)this.actual).isReadOnly()).overridingErrorMessage("Expected DB to not be read only but was.", new Object[0])).isFalse();
        return this;
    }

    @TargetApi(value=16)
    public SqliteDatabaseAssert isWriteAheadLoggingEnabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SQLiteDatabase)this.actual).isWriteAheadLoggingEnabled()).overridingErrorMessage("Expected DB to have write-ahead logging enabled but was disabled.", new Object[0])).isTrue();
        return this;
    }

    @TargetApi(value=16)
    public SqliteDatabaseAssert isWriteAheadLoggingDisabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SQLiteDatabase)this.actual).isWriteAheadLoggingEnabled()).overridingErrorMessage("Expected DB to have write-ahead logging disabled but was enabled.", new Object[0])).isFalse();
        return this;
    }
}

