/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.database;

import android.database.Cursor;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectArrayAssert;
import org.assertj.core.api.Assertions;

public abstract class AbstractCursorAssert<S extends AbstractCursorAssert<S, A>, A extends Cursor>
extends AbstractAssert<S, A> {
    public AbstractCursorAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasColumnCount(int count) {
        this.isNotNull();
        int actualCount = ((Cursor)this.actual).getColumnCount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected column count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return (S)((Object)((AbstractCursorAssert)this.myself));
    }

    public S hasColumn(String name) {
        this.isNotNull();
        ((AbstractObjectArrayAssert)Assertions.assertThat((Object[])((Cursor)this.actual).getColumnNames()).overridingErrorMessage("Expected to have column <%s> but did not.", new Object[]{name})).contains((Object[])new String[]{name});
        return (S)((Object)((AbstractCursorAssert)this.myself));
    }

    public S hasColumns(String ... names) {
        this.isNotNull();
        Assertions.assertThat((Object[])((Cursor)this.actual).getColumnNames()).contains((Object[])names);
        return (S)((Object)((AbstractCursorAssert)this.myself));
    }

    public S hasCount(int count) {
        this.isNotNull();
        int actualCount = ((Cursor)this.actual).getCount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return (S)((Object)((AbstractCursorAssert)this.myself));
    }

    public S hasPosition(int position) {
        this.isNotNull();
        int actualPosition = ((Cursor)this.actual).getPosition();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPosition).overridingErrorMessage("Expected position <%s> but was <%s>.", new Object[]{position, actualPosition})).isEqualTo(position);
        return (S)((Object)((AbstractCursorAssert)this.myself));
    }

    public S isAfterLast() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Cursor)this.actual).isAfterLast()).overridingErrorMessage("Expected to be after last but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractCursorAssert)this.myself));
    }

    public S isNotAfterLast() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Cursor)this.actual).isAfterLast()).overridingErrorMessage("Expected to not be after last but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractCursorAssert)this.myself));
    }

    public S isBeforeFirst() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Cursor)this.actual).isBeforeFirst()).overridingErrorMessage("Expected to be before first but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractCursorAssert)this.myself));
    }

    public S isNotBeforeFirst() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Cursor)this.actual).isBeforeFirst()).overridingErrorMessage("Expected to not be before first but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractCursorAssert)this.myself));
    }

    public S isClosed() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Cursor)this.actual).isClosed()).overridingErrorMessage("Expected to be closed but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractCursorAssert)this.myself));
    }

    public S isNotClosed() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Cursor)this.actual).isClosed()).overridingErrorMessage("Expected to not be closed but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractCursorAssert)this.myself));
    }

    public S isFirst() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Cursor)this.actual).isFirst()).overridingErrorMessage("Expected to be at first but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractCursorAssert)this.myself));
    }

    public S isNotFirst() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Cursor)this.actual).isFirst()).overridingErrorMessage("Expected to not be at first but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractCursorAssert)this.myself));
    }

    public S isLast() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Cursor)this.actual).isLast()).overridingErrorMessage("Expected to be at last but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractCursorAssert)this.myself));
    }

    public S isNotLast() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Cursor)this.actual).isLast()).overridingErrorMessage("Expected to not be at last but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractCursorAssert)this.myself));
    }
}

