/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.content.res;

import android.annotation.TargetApi;
import android.content.res.Configuration;
import org.assertj.android.api.view.AbstractViewAssert;
import org.assertj.android.internal.IntegerUtils;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class ConfigurationAssert
extends AbstractAssert<ConfigurationAssert, Configuration> {
    public ConfigurationAssert(Configuration actual) {
        super((Object)actual, ConfigurationAssert.class);
    }

    @TargetApi(value=17)
    public ConfigurationAssert hasLayoutDirection(int layoutDirection) {
        this.isNotNull();
        int actualLayoutDirection = ((Configuration)this.actual).getLayoutDirection();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualLayoutDirection).overridingErrorMessage("Expected layout direction to be <%s> but was <%s>.", new Object[]{AbstractViewAssert.layoutDirectionToString(layoutDirection), AbstractViewAssert.layoutDirectionToString(actualLayoutDirection)})).isEqualTo(layoutDirection);
        return this;
    }

    @TargetApi(value=19)
    public ConfigurationAssert hasMnc(int mnc) {
        this.isNotNull();
        int actualMnc = ((Configuration)this.actual).mnc;
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualMnc).overridingErrorMessage("Expected mnc to be <%s> but was <%s>.", new Object[]{mnc, actualMnc})).isEqualTo(mnc);
        return this;
    }

    @TargetApi(value=19)
    public ConfigurationAssert hasMncZero() {
        this.isNotNull();
        int actualMnc = ((Configuration)this.actual).mnc;
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualMnc).overridingErrorMessage("Expected mnc to be zero but was <%s>.", new Object[]{actualMnc})).isEqualTo(65535);
        return this;
    }

    public static String uiModeTypeToString(int mode) {
        return IntegerUtils.buildNamedValueString(mode).value(1, "normal").value(5, "appliance").value(3, "car").value(2, "desk").value(4, "television").value(0, "undefined").value(6, "watch").get();
    }
}

