/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.content;

import android.content.SharedPreferences;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractMapAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.MapEntry;

public abstract class AbstractSharedPreferencesAssert<S extends AbstractSharedPreferencesAssert<S, A>, A extends SharedPreferences>
extends AbstractAssert<S, A> {
    protected AbstractSharedPreferencesAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasKey(String key) {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SharedPreferences)this.actual).contains(key)).overridingErrorMessage("Expected key <%s> to be present but it was not.", new Object[]{key})).isTrue();
        return (S)((Object)((AbstractSharedPreferencesAssert)this.myself));
    }

    public S doesNotHaveKey(String key) {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SharedPreferences)this.actual).contains(key)).overridingErrorMessage("Expected key <%s> not to be present but it was.", new Object[]{key})).isFalse();
        return (S)((Object)((AbstractSharedPreferencesAssert)this.myself));
    }

    public S contains(String key, String value) {
        this.isNotNull();
        ((AbstractMapAssert)Assertions.assertThat((Map)((SharedPreferences)this.actual).getAll()).overridingErrorMessage("Expected preferences to contain <%s> but it does not.", new Object[]{AbstractSharedPreferencesAssert.stringOf(key, value)})).contains(new MapEntry[]{MapEntry.entry((Object)key, (Object)value)});
        return (S)((Object)((AbstractSharedPreferencesAssert)this.myself));
    }

    public S doesNotContain(String key, String value) {
        this.isNotNull();
        ((AbstractMapAssert)Assertions.assertThat((Map)((SharedPreferences)this.actual).getAll()).overridingErrorMessage("Expected preferences not to contain <%s> but it does.", new Object[]{AbstractSharedPreferencesAssert.stringOf(key, value)})).doesNotContain(new MapEntry[]{MapEntry.entry((Object)key, (Object)value)});
        return (S)((Object)((AbstractSharedPreferencesAssert)this.myself));
    }

    public S contains(String key, int value) {
        this.isNotNull();
        ((AbstractMapAssert)Assertions.assertThat((Map)((SharedPreferences)this.actual).getAll()).overridingErrorMessage("Expected preferences to contain <%s> but it does not.", new Object[]{AbstractSharedPreferencesAssert.stringOf(key, value)})).contains(new MapEntry[]{MapEntry.entry((Object)key, (Object)value)});
        return (S)((Object)((AbstractSharedPreferencesAssert)this.myself));
    }

    public S doesNotContain(String key, int value) {
        this.isNotNull();
        ((AbstractMapAssert)Assertions.assertThat((Map)((SharedPreferences)this.actual).getAll()).overridingErrorMessage("Expected preferences not to contain <%s> but it does.", new Object[]{AbstractSharedPreferencesAssert.stringOf(key, value)})).doesNotContain(new MapEntry[]{MapEntry.entry((Object)key, (Object)value)});
        return (S)((Object)((AbstractSharedPreferencesAssert)this.myself));
    }

    public S contains(String key, boolean value) {
        this.isNotNull();
        ((AbstractMapAssert)Assertions.assertThat((Map)((SharedPreferences)this.actual).getAll()).overridingErrorMessage("Expected preferences to contain <%s> but it does not.", new Object[]{AbstractSharedPreferencesAssert.stringOf(key, value)})).contains(new MapEntry[]{MapEntry.entry((Object)key, (Object)value)});
        return (S)((Object)((AbstractSharedPreferencesAssert)this.myself));
    }

    public S doesNotContain(String key, boolean value) {
        this.isNotNull();
        ((AbstractMapAssert)Assertions.assertThat((Map)((SharedPreferences)this.actual).getAll()).overridingErrorMessage("Expected preferences not to contain <%s> but it does.", new Object[]{AbstractSharedPreferencesAssert.stringOf(key, value)})).doesNotContain(new MapEntry[]{MapEntry.entry((Object)key, (Object)value)});
        return (S)((Object)((AbstractSharedPreferencesAssert)this.myself));
    }

    public S contains(String key, float value) {
        this.isNotNull();
        ((AbstractMapAssert)Assertions.assertThat((Map)((SharedPreferences)this.actual).getAll()).overridingErrorMessage("Expected preferences to contain <%s> but it does not.", new Object[]{AbstractSharedPreferencesAssert.stringOf(key, Float.valueOf(value))})).contains(new MapEntry[]{MapEntry.entry((Object)key, (Object)Float.valueOf(value))});
        return (S)((Object)((AbstractSharedPreferencesAssert)this.myself));
    }

    public S doesNotContain(String key, float value) {
        this.isNotNull();
        ((AbstractMapAssert)Assertions.assertThat((Map)((SharedPreferences)this.actual).getAll()).overridingErrorMessage("Expected preferences not to contain <%s> but it does.", new Object[]{AbstractSharedPreferencesAssert.stringOf(key, Float.valueOf(value))})).doesNotContain(new MapEntry[]{MapEntry.entry((Object)key, (Object)Float.valueOf(value))});
        return (S)((Object)((AbstractSharedPreferencesAssert)this.myself));
    }

    public S contains(String key, long value) {
        this.isNotNull();
        ((AbstractMapAssert)Assertions.assertThat((Map)((SharedPreferences)this.actual).getAll()).overridingErrorMessage("Expected preferences to contain <%s> but it does not.", new Object[]{AbstractSharedPreferencesAssert.stringOf(key, value)})).contains(new MapEntry[]{MapEntry.entry((Object)key, (Object)value)});
        return (S)((Object)((AbstractSharedPreferencesAssert)this.myself));
    }

    public S doesNotContain(String key, long value) {
        this.isNotNull();
        ((AbstractMapAssert)Assertions.assertThat((Map)((SharedPreferences)this.actual).getAll()).overridingErrorMessage("Expected preferences not to contain <%s> but it does.", new Object[]{AbstractSharedPreferencesAssert.stringOf(key, value)})).doesNotContain(new MapEntry[]{MapEntry.entry((Object)key, (Object)value)});
        return (S)((Object)((AbstractSharedPreferencesAssert)this.myself));
    }

    public S contains(String key, Set<String> value) {
        this.isNotNull();
        ((AbstractMapAssert)Assertions.assertThat((Map)((SharedPreferences)this.actual).getAll()).overridingErrorMessage("Expected preferences to contain <%s> but it does not.", new Object[]{AbstractSharedPreferencesAssert.stringOf(key, value)})).contains(new MapEntry[]{MapEntry.entry((Object)key, value)});
        return (S)((Object)((AbstractSharedPreferencesAssert)this.myself));
    }

    public S doesNotContain(String key, Set<String> value) {
        this.isNotNull();
        ((AbstractMapAssert)Assertions.assertThat((Map)((SharedPreferences)this.actual).getAll()).overridingErrorMessage("Expected preferences not to contain <%s> but it does.", new Object[]{AbstractSharedPreferencesAssert.stringOf(key, value)})).doesNotContain(new MapEntry[]{MapEntry.entry((Object)key, value)});
        return (S)((Object)((AbstractSharedPreferencesAssert)this.myself));
    }

    private static String stringOf(String key, Object value) {
        return "{" + key + "=" + value + '}';
    }
}

