/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.bluetooth;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothGattService;
import java.util.UUID;
import org.assertj.android.internal.IntegerUtils;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

@TargetApi(value=18)
public class BluetoothGattServiceAssert
extends AbstractAssert<BluetoothGattServiceAssert, BluetoothGattService> {
    public BluetoothGattServiceAssert(BluetoothGattService actual) {
        super((Object)actual, BluetoothGattServiceAssert.class);
    }

    public BluetoothGattServiceAssert hasInstanceId(int id) {
        this.isNotNull();
        int actualId = ((BluetoothGattService)this.actual).getInstanceId();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected instance ID <%s> but was <%s>", new Object[]{id, actualId})).isEqualTo(id);
        return this;
    }

    public BluetoothGattServiceAssert hasType(int type) {
        this.isNotNull();
        int actualType = ((BluetoothGattService)this.actual).getType();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualType).overridingErrorMessage("Expected type <%s> but was <%s>.", new Object[]{BluetoothGattServiceAssert.typeToString(type), BluetoothGattServiceAssert.typeToString(actualType)})).isEqualTo(type);
        return this;
    }

    public BluetoothGattServiceAssert hasUuid(UUID uuid) {
        this.isNotNull();
        UUID actualUuid = ((BluetoothGattService)this.actual).getUuid();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)uuid).overridingErrorMessage("Expected UUID <%s> but was <%s>.", new Object[]{uuid, actualUuid})).isEqualTo((Object)uuid);
        return this;
    }

    public static String typeToString(int type) {
        return IntegerUtils.buildNamedValueString(type).value(0, "primary").value(1, "secondary").get();
    }
}

