/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.bluetooth;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothGattCharacteristic;
import java.util.Arrays;
import java.util.UUID;
import org.assertj.android.internal.IntegerUtils;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

@TargetApi(value=18)
public class BluetoothGattCharacteristicAssert
extends AbstractAssert<BluetoothGattCharacteristicAssert, BluetoothGattCharacteristic> {
    public BluetoothGattCharacteristicAssert(BluetoothGattCharacteristic actual) {
        super((Object)actual, BluetoothGattCharacteristicAssert.class);
    }

    public BluetoothGattCharacteristicAssert hasInstanceId(int id) {
        this.isNotNull();
        int actualId = ((BluetoothGattCharacteristic)this.actual).getInstanceId();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected instance ID <%s> but was <%s>", new Object[]{id, actualId})).isEqualTo(id);
        return this;
    }

    public BluetoothGattCharacteristicAssert hasPermissions(int permissions) {
        this.isNotNull();
        int actualPermissions = ((BluetoothGattCharacteristic)this.actual).getPermissions();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPermissions).overridingErrorMessage("Expected permissions <%s> but was <%s>.", new Object[]{BluetoothGattCharacteristicAssert.permissionsToString(permissions), BluetoothGattCharacteristicAssert.permissionsToString(actualPermissions)})).isEqualTo(permissions);
        return this;
    }

    public BluetoothGattCharacteristicAssert hasProperties(int properties) {
        this.isNotNull();
        int actualProperties = ((BluetoothGattCharacteristic)this.actual).getProperties();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualProperties).overridingErrorMessage("Expected properties <%s> but was <%s>.", new Object[]{BluetoothGattCharacteristicAssert.propertiesToString(properties), BluetoothGattCharacteristicAssert.propertiesToString(actualProperties)})).isEqualTo(properties);
        return this;
    }

    public BluetoothGattCharacteristicAssert hasUuid(UUID uuid) {
        this.isNotNull();
        UUID actualUuid = ((BluetoothGattCharacteristic)this.actual).getUuid();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)uuid).overridingErrorMessage("Expected UUID <%s> but was <%s>.", new Object[]{uuid, actualUuid})).isEqualTo((Object)uuid);
        return this;
    }

    public BluetoothGattCharacteristicAssert hasValue(byte[] value) {
        this.isNotNull();
        byte[] actualValue = ((BluetoothGattCharacteristic)this.actual).getValue();
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])actualValue).overridingErrorMessage("Expected value <%s> but was <%s>.", new Object[]{Arrays.toString(value), Arrays.toString(actualValue)})).isEqualTo((Object)value);
        return this;
    }

    public BluetoothGattCharacteristicAssert hasWriteType(int writeType) {
        this.isNotNull();
        int actualWriteType = ((BluetoothGattCharacteristic)this.actual).getWriteType();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualWriteType).overridingErrorMessage("Expected write type <%s> but was <%s>.", new Object[]{BluetoothGattCharacteristicAssert.writeTypeToString(writeType), BluetoothGattCharacteristicAssert.writeTypeToString(actualWriteType)})).isEqualTo(writeType);
        return this;
    }

    public static String writeTypeToString(int writeType) {
        return IntegerUtils.buildNamedValueString(writeType).value(2, "default").value(1, "no_response").value(4, "signed").get();
    }

    public static String permissionsToString(int permissions) {
        return IntegerUtils.buildBitMaskString(permissions).flag(1, "read").flag(2, "read_encrypted").flag(4, "read_encrypted_mitm").flag(16, "write").flag(32, "write_encrypted").flag(64, "write_encrypted_mitm").flag(128, "write_signed").flag(256, "write_signed_mitm").get();
    }

    public static String propertiesToString(int properties) {
        return IntegerUtils.buildBitMaskString(properties).flag(1, "broadcast").flag(128, "extended_props").flag(32, "indicate").flag(16, "notify").flag(2, "read").flag(64, "signed_write").flag(8, "write").flag(4, "write_no_response").get();
    }
}

