/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.app;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.PendingIntent;
import android.graphics.Bitmap;
import org.assertj.android.internal.IntegerUtils;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;

public class NotificationAssert
extends AbstractAssert<NotificationAssert, Notification> {
    public NotificationAssert(Notification actual) {
        super((Object)actual, NotificationAssert.class);
    }

    public NotificationAssert hasContentIntent(PendingIntent intent) {
        this.isNotNull();
        Assertions.assertThat((Object)((Notification)this.actual).contentIntent).isEqualTo((Object)intent);
        return this;
    }

    public NotificationAssert hasDefaults(int defaults) {
        this.isNotNull();
        int actualDefaults = ((Notification)this.actual).defaults;
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualDefaults).overridingErrorMessage("Expected defaults <%s> but was <%s>.", new Object[]{defaults, actualDefaults})).isEqualTo(defaults);
        return this;
    }

    public NotificationAssert hasDeleteIntent(PendingIntent intent) {
        this.isNotNull();
        Assertions.assertThat((Object)((Notification)this.actual).deleteIntent).isEqualTo((Object)intent);
        return this;
    }

    public NotificationAssert hasFlags(int flags) {
        this.isNotNull();
        int actualFlags = ((Notification)this.actual).flags;
        ((AbstractIntegerAssert)Assertions.assertThat((int)(actualFlags & flags)).overridingErrorMessage("Expected flags <%s> but was <%s>.", new Object[]{NotificationAssert.flagsToString(flags), NotificationAssert.flagsToString(actualFlags & flags)})).isEqualTo(flags);
        return this;
    }

    public NotificationAssert hasOnlyFlags(int flags) {
        this.isNotNull();
        int actualFlags = ((Notification)this.actual).flags;
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualFlags).overridingErrorMessage("Expected flags <%s> but was <%s>.", new Object[]{NotificationAssert.flagsToString(flags), NotificationAssert.flagsToString(actualFlags)})).isEqualTo(flags);
        return this;
    }

    @TargetApi(value=9)
    public NotificationAssert hasFullScreenIntent(PendingIntent intent) {
        this.isNotNull();
        Assertions.assertThat((Object)((Notification)this.actual).fullScreenIntent).isEqualTo((Object)intent);
        return this;
    }

    @TargetApi(value=20)
    public NotificationAssert hasGroup(String group) {
        this.isNotNull();
        String actualGroup = ((Notification)this.actual).getGroup();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)((Notification)this.actual).getGroup()).overridingErrorMessage("Expected group <%s> but was <%s>.", new Object[]{group, actualGroup})).isEqualTo((Object)group);
        return this;
    }

    public NotificationAssert hasIcon(int resId) {
        this.isNotNull();
        int actualId = ((Notification)this.actual).icon;
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected icon with ID <%s> but was <%s>.", new Object[]{resId, actualId})).isEqualTo(resId);
        return this;
    }

    public NotificationAssert hasIconLevel(int level) {
        this.isNotNull();
        int actualLevel = ((Notification)this.actual).iconLevel;
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualLevel).overridingErrorMessage("Expected icon level <%s> but was <%s>.", new Object[]{level, actualLevel})).isEqualTo(level);
        return this;
    }

    @TargetApi(value=11)
    public NotificationAssert hasLargeIcon(Bitmap bitmap) {
        this.isNotNull();
        Assertions.assertThat((Object)((Notification)this.actual).largeIcon).isEqualTo((Object)bitmap);
        return this;
    }

    public NotificationAssert hasLedColor(int color) {
        this.isNotNull();
        int actualColor = ((Notification)this.actual).ledARGB;
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualColor).overridingErrorMessage("Expected LED color <%s> but was <%s>.", new Object[]{Integer.toHexString(color), Integer.toHexString(actualColor)})).isEqualTo(color);
        return this;
    }

    public NotificationAssert hasLedOffMs(int length) {
        this.isNotNull();
        int actualLength = ((Notification)this.actual).ledOffMS;
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualLength).overridingErrorMessage("Expected LED off time (ms) <%s> but was <%s>.", new Object[]{length, actualLength})).isEqualTo(length);
        return this;
    }

    public NotificationAssert hasLedOnMs(int length) {
        this.isNotNull();
        int actualLength = ((Notification)this.actual).ledOnMS;
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualLength).overridingErrorMessage("Expected LED on time (ms) <%s> but was <%s>.", new Object[]{length, actualLength})).isEqualTo(length);
        return this;
    }

    public NotificationAssert hasNumber(int number) {
        this.isNotNull();
        int actualNumber = ((Notification)this.actual).number;
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualNumber).overridingErrorMessage("Expected number <%s> but was <%s>.", new Object[]{number, actualNumber})).isEqualTo(number);
        return this;
    }

    @TargetApi(value=16)
    public NotificationAssert hasPriority(int priority) {
        this.isNotNull();
        int actualPriority = ((Notification)this.actual).priority;
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPriority).overridingErrorMessage("Expected priority <%s> but was <%s>.", new Object[]{NotificationAssert.priorityToString(priority), NotificationAssert.priorityToString(actualPriority)})).isEqualTo(priority);
        return this;
    }

    @TargetApi(value=20)
    public NotificationAssert hasSortKey(String sortKey) {
        this.isNotNull();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)((Notification)this.actual).getSortKey()).overridingErrorMessage("Expected sortKey <%s> but was <%s>.", new Object[]{sortKey, ((Notification)this.actual).getSortKey()})).isEqualTo((Object)sortKey);
        return this;
    }

    public NotificationAssert hasTickerText(CharSequence text) {
        this.isNotNull();
        Assertions.assertThat((CharSequence)((Notification)this.actual).tickerText).isEqualTo((Object)text);
        return this;
    }

    public NotificationAssert hasVibration(long[] vibration) {
        this.isNotNull();
        Assertions.assertThat((long[])((Notification)this.actual).vibrate).isEqualTo((Object)vibration);
        return this;
    }

    public NotificationAssert hasWhen(long when) {
        this.isNotNull();
        long actualWhen = ((Notification)this.actual).when;
        ((AbstractLongAssert)Assertions.assertThat((long)actualWhen).overridingErrorMessage("Expected when <%s> but was <%s>.", new Object[]{when, actualWhen})).isEqualTo(when);
        return this;
    }

    public static String flagsToString(int flags) {
        return IntegerUtils.buildBitMaskString(flags).flag(16, "autoCancel").flag(64, "foregroundService").flag(4, "insistent").flag(32, "noClear").flag(2, "ongoingEvent").flag(8, "onlyAlertOnce").flag(1, "showLights").flag(128, "highPriority").get();
    }

    public static String priorityToString(int priority) {
        return IntegerUtils.buildNamedValueString(priority).value(-2, "min").value(-1, "low").value(0, "default").value(1, "high").value(2, "max").get();
    }
}

