/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.app;

import android.annotation.TargetApi;
import android.app.FragmentManager;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

@TargetApi(value=11)
public class FragmentManagerAssert
extends AbstractAssert<FragmentManagerAssert, FragmentManager> {
    public FragmentManagerAssert(FragmentManager actual) {
        super((Object)actual, FragmentManagerAssert.class);
    }

    public FragmentManagerAssert hasFragmentWithId(int id) {
        this.isNotNull();
        ((AbstractObjectAssert)Assertions.assertThat((Object)((FragmentManager)this.actual).findFragmentById(id)).overridingErrorMessage("Expected fragment with ID <%s> but was not found.", new Object[]{id})).isNotNull();
        return this;
    }

    public FragmentManagerAssert hasFragmentWithTag(String tag) {
        this.isNotNull();
        ((AbstractObjectAssert)Assertions.assertThat((Object)((FragmentManager)this.actual).findFragmentByTag(tag)).overridingErrorMessage("Expected fragment with tag <%s> but was not found.", new Object[]{tag})).isNotNull();
        return this;
    }

    public FragmentManagerAssert hasBackStackEntryCount(int count) {
        this.isNotNull();
        int actualCount = ((FragmentManager)this.actual).getBackStackEntryCount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected back stack entry count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public FragmentManagerAssert doesNotHaveFragmentWithId(int id) {
        this.isNotNull();
        ((AbstractObjectAssert)Assertions.assertThat((Object)((FragmentManager)this.actual).findFragmentById(id)).overridingErrorMessage("Expected fragment with ID <%s> not to be present but was.", new Object[]{id})).isNull();
        return this;
    }

    public FragmentManagerAssert doesNotHaveFragmentWithTag(String tag) {
        this.isNotNull();
        ((AbstractObjectAssert)Assertions.assertThat((Object)((FragmentManager)this.actual).findFragmentByTag(tag)).overridingErrorMessage("Expected fragment with tag <%s> not to be present but was.", new Object[]{tag})).isNull();
        return this;
    }
}

