/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.animation;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import java.util.List;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

@TargetApi(value=11)
public abstract class AbstractAnimatorAssert<S extends AbstractAnimatorAssert<S, A>, A extends Animator>
extends AbstractAssert<S, A> {
    protected AbstractAnimatorAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasDuration(long duration) {
        this.isNotNull();
        long actualDuration = ((Animator)this.actual).getDuration();
        ((AbstractLongAssert)Assertions.assertThat((long)actualDuration).overridingErrorMessage("Expected duration <%s> but was <%s>.", new Object[]{duration, actualDuration})).isEqualTo(duration);
        return (S)((Object)((AbstractAnimatorAssert)this.myself));
    }

    @TargetApi(value=18)
    public S hasInterpolator(TimeInterpolator interpolator) {
        this.isNotNull();
        TimeInterpolator actualInterpolator = ((Animator)this.actual).getInterpolator();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualInterpolator).overridingErrorMessage("Expected interpolator <%s> but was <%s>.", new Object[]{interpolator, actualInterpolator})).isEqualTo((Object)interpolator);
        return (S)((Object)((AbstractAnimatorAssert)this.myself));
    }

    public S hasListener(Animator.AnimatorListener listener) {
        this.isNotNull();
        ((AbstractListAssert)Assertions.assertThat((List)((Animator)this.actual).getListeners()).overridingErrorMessage("Expected listener <%s> but was not present.", new Object[0])).contains((Object[])new Animator.AnimatorListener[]{listener});
        return (S)((Object)((AbstractAnimatorAssert)this.myself));
    }

    public S hasStartDelay(long delay) {
        this.isNotNull();
        long actualDelay = ((Animator)this.actual).getStartDelay();
        ((AbstractLongAssert)Assertions.assertThat((long)actualDelay).overridingErrorMessage("Expected start delay <%s> but was <%s>.", new Object[]{delay, actualDelay})).isEqualTo(delay);
        return (S)((Object)((AbstractAnimatorAssert)this.myself));
    }

    @TargetApi(value=19)
    public S isPaused() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Animator)this.actual).isPaused()).overridingErrorMessage("Expected to be paused but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractAnimatorAssert)this.myself));
    }

    @TargetApi(value=19)
    public S isNotPaused() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Animator)this.actual).isPaused()).overridingErrorMessage("Expected to not be paused but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractAnimatorAssert)this.myself));
    }

    public S isRunning() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Animator)this.actual).isRunning()).overridingErrorMessage("Expected to be running but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractAnimatorAssert)this.myself));
    }

    public S isNotRunning() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Animator)this.actual).isRunning()).overridingErrorMessage("Expected to not be running but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractAnimatorAssert)this.myself));
    }

    @TargetApi(value=14)
    public S isStarted() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Animator)this.actual).isStarted()).overridingErrorMessage("Expected to be started but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractAnimatorAssert)this.myself));
    }

    @TargetApi(value=14)
    public S isNotStarted() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Animator)this.actual).isStarted()).overridingErrorMessage("Expected to not be started but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractAnimatorAssert)this.myself));
    }
}

