/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.accessibilityservice;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.annotation.TargetApi;
import org.assertj.android.internal.IntegerUtils;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class AccessibilityServiceInfoAssert
extends AbstractAssert<AccessibilityServiceInfoAssert, AccessibilityServiceInfo> {
    public AccessibilityServiceInfoAssert(AccessibilityServiceInfo actual) {
        super((Object)actual, AccessibilityServiceInfoAssert.class);
    }

    @TargetApi(value=18)
    public AccessibilityServiceInfoAssert hasCapabilities(int capabilities) {
        this.isNotNull();
        int actualCapabilities = ((AccessibilityServiceInfo)this.actual).getCapabilities();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCapabilities).overridingErrorMessage("Expected capabilities <%s> but was <%s>.", new Object[]{AccessibilityServiceInfoAssert.capabilitiesToString(capabilities), AccessibilityServiceInfoAssert.capabilitiesToString(actualCapabilities)})).isEqualTo(capabilities);
        return this;
    }

    @TargetApi(value=18)
    public AccessibilityServiceInfoAssert hasDescription(String description) {
        this.isNotNull();
        String actualDescription = ((AccessibilityServiceInfo)this.actual).getDescription();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualDescription).overridingErrorMessage("Expected description <%s> but was <%s>.", new Object[]{description, actualDescription})).isEqualTo((Object)description);
        return this;
    }

    @TargetApi(value=14)
    public AccessibilityServiceInfoAssert hasId(String id) {
        this.isNotNull();
        String actualId = ((AccessibilityServiceInfo)this.actual).getId();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualId).overridingErrorMessage("Expected ID <%s> but was <%s>.", new Object[]{id, actualId})).isEqualTo((Object)id);
        return this;
    }

    @TargetApi(value=14)
    public AccessibilityServiceInfoAssert hasSettingsActivityName(String name) {
        this.isNotNull();
        String actualName = ((AccessibilityServiceInfo)this.actual).getSettingsActivityName();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualName).overridingErrorMessage("Expected settings activity name <%s> but was <%s>.", new Object[]{name, actualName})).isEqualTo((Object)name);
        return this;
    }

    public static String capabilitiesToString(int capabilities) {
        return IntegerUtils.buildBitMaskString(capabilities).flag(4, "request_enhanced_web_accessibility").flag(8, "request_filter_key_events").flag(2, "request_touch_exploration").flag(1, "retrieve_window_content").get();
    }
}

