/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.anvil.compiler.codegen;

import com.google.auto.service.AutoService;
import com.squareup.anvil.compiler.UtilsKt;
import com.squareup.anvil.compiler.api.AnvilContext;
import com.squareup.anvil.compiler.api.CodeGenerator;
import com.squareup.anvil.compiler.codegen.AnnotationReferenceExtensionsKt;
import com.squareup.anvil.compiler.codegen.CheckOnlyCodeGenerator;
import com.squareup.anvil.compiler.codegen.MergeAnnotationsCheckGenerator;
import com.squareup.anvil.compiler.internal.reference.AnnotationReference;
import com.squareup.anvil.compiler.internal.reference.AnvilModuleDescriptorKt;
import com.squareup.anvil.compiler.internal.reference.ClassReference;
import com.squareup.anvil.compiler.internal.reference.ClassReferenceKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\f\u0010\u0010\u001a\u00020\u0004*\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/squareup/anvil/compiler/codegen/MergeAnnotationsCheckGenerator;", "Lcom/squareup/anvil/compiler/codegen/CheckOnlyCodeGenerator;", "()V", "checkCode", "", "codeGenDir", "Ljava/io/File;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "projectFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "isApplicable", "", "context", "Lcom/squareup/anvil/compiler/api/AnvilContext;", "checkNotAnnotatedWithDaggerAnnotation", "Lcom/squareup/anvil/compiler/internal/reference/AnnotationReference;", "checkSingleAnnotation", "", "compiler"})
@AutoService(value={CodeGenerator.class})
@SourceDebugExtension(value={"SMAP\nMergeAnnotationsCheckGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MergeAnnotationsCheckGenerator.kt\ncom/squareup/anvil/compiler/codegen/MergeAnnotationsCheckGenerator\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1313#2:78\n1314#2:82\n1#3:79\n288#4,2:80\n1655#4,8:83\n*S KotlinDebug\n*F\n+ 1 MergeAnnotationsCheckGenerator.kt\ncom/squareup/anvil/compiler/codegen/MergeAnnotationsCheckGenerator\n*L\n28#1:78\n28#1:82\n46#1:80,2\n52#1:83,8\n*E\n"})
public final class MergeAnnotationsCheckGenerator
extends CheckOnlyCodeGenerator {
    public boolean isApplicable(@NotNull AnvilContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return !context.getDisableComponentMerging();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void checkCode(@NotNull File codeGenDir, @NotNull ModuleDescriptor module, @NotNull Collection<? extends KtFile> projectFiles) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)codeGenDir, (String)"codeGenDir");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(projectFiles, (String)"projectFiles");
        Sequence sequence = AnvilModuleDescriptorKt.classAndInnerClassReferences(projectFiles, (ModuleDescriptor)module);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v0;
            Object object;
            block3: {
                void $this$firstOrNull$iv;
                ClassReference.Psi clazz2 = (ClassReference.Psi)element$iv;
                boolean bl = false;
                object = new FqName[]{UtilsKt.getMergeComponentFqName(), UtilsKt.getMergeSubcomponentFqName(), UtilsKt.getMergeModulesFqName(), UtilsKt.getMergeInterfacesFqName()};
                object = AnnotationReferenceExtensionsKt.findAll$default(clazz2.getAnnotations(), (FqName[])object, null, 2, null);
                if (object.isEmpty()) {
                    boolean bl2 = false;
                    continue;
                }
                List annotations2 = (List)object;
                this.checkSingleAnnotation(annotations2);
                AnnotationReferenceExtensionsKt.checkNoDuplicateScope(annotations2, false);
                Iterable bl2 = annotations2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    AnnotationReference.Psi it = (AnnotationReference.Psi)element$iv2;
                    boolean bl3 = false;
                    if (!(!Intrinsics.areEqual((Object)it.getFqName(), (Object)UtilsKt.getMergeInterfacesFqName()))) continue;
                    v0 = element$iv2;
                    break block3;
                }
                v0 = null;
            }
            if ((object = (AnnotationReference.Psi)v0) == null) continue;
            this.checkNotAnnotatedWithDaggerAnnotation((AnnotationReference)object);
        }
    }

    private final void checkSingleAnnotation(List<? extends AnnotationReference> $this$checkSingleAnnotation) {
        Iterable $this$distinctBy$iv = $this$checkSingleAnnotation;
        boolean $i$f$distinctBy = false;
        HashSet<FqName> set$iv = new HashSet<FqName>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            AnnotationReference it = (AnnotationReference)e$iv;
            boolean bl = false;
            FqName key$iv = it.getFqName();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List distinctAnnotations = list$iv;
        if (distinctAnnotations.size() > 1) {
            throw ClassReferenceKt.AnvilCompilationExceptionClassReference$default((ClassReference)$this$checkSingleAnnotation.get(0).declaringClass(), (String)("It's only allowed to have one single type of @Merge* annotation, however multiple instances of the same annotation are allowed. You mix " + CollectionsKt.joinToString$default((Iterable)distinctAnnotations, null, (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)checkSingleAnnotation.1.INSTANCE, (int)25, null) + " and this is forbidden."), null, (int)4, null);
        }
    }

    private final void checkNotAnnotatedWithDaggerAnnotation(AnnotationReference $this$checkNotAnnotatedWithDaggerAnnotation) {
        if ($this$checkNotAnnotatedWithDaggerAnnotation.declaringClass().isAnnotatedWith(AnnotationReferenceExtensionsKt.getDaggerAnnotationFqName($this$checkNotAnnotatedWithDaggerAnnotation))) {
            throw ClassReferenceKt.AnvilCompilationExceptionClassReference$default((ClassReference)$this$checkNotAnnotatedWithDaggerAnnotation.declaringClass(), (String)("When using @" + $this$checkNotAnnotatedWithDaggerAnnotation.getFqName().shortName() + " it's not allowed to annotate the same class with @" + AnnotationReferenceExtensionsKt.getDaggerAnnotationFqName($this$checkNotAnnotatedWithDaggerAnnotation).shortName() + ". The Dagger annotation will be generated."), null, (int)4, null);
        }
    }
}

