/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.anvil.compiler.internal.reference;

import com.squareup.anvil.annotations.ExperimentalAnvilApi;
import com.squareup.anvil.compiler.internal.reference.AnnotatedReference;
import com.squareup.anvil.compiler.internal.reference.AnnotationReference;
import com.squareup.anvil.compiler.internal.reference.AnnotationReferenceKt;
import com.squareup.anvil.compiler.internal.reference.AnvilModuleDescriptor;
import com.squareup.anvil.compiler.internal.reference.FunctionReference;
import com.squareup.anvil.compiler.internal.reference.FunctionReferenceKt;
import com.squareup.anvil.compiler.internal.reference.ParameterReference;
import com.squareup.anvil.compiler.internal.reference.ParameterReferenceKt;
import com.squareup.anvil.compiler.internal.reference.TypeReference;
import com.squareup.anvil.compiler.internal.reference.TypeReferenceKt;
import com.squareup.anvil.compiler.internal.reference.Visibility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u0011\u0012B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\u0013\u0014\u00a8\u0006\u0015"}, d2={"Lcom/squareup/anvil/compiler/internal/reference/TopLevelFunctionReference;", "Lcom/squareup/anvil/compiler/internal/reference/AnnotatedReference;", "Lcom/squareup/anvil/compiler/internal/reference/FunctionReference;", "()V", "returnType", "Lcom/squareup/anvil/compiler/internal/reference/TypeReference;", "getReturnType", "()Lcom/squareup/anvil/compiler/internal/reference/TypeReference;", "equals", "", "other", "", "hashCode", "", "returnTypeOrNull", "toString", "", "Descriptor", "Psi", "Lcom/squareup/anvil/compiler/internal/reference/TopLevelFunctionReference$Descriptor;", "Lcom/squareup/anvil/compiler/internal/reference/TopLevelFunctionReference$Psi;", "compiler-utils"})
@ExperimentalAnvilApi
public abstract class TopLevelFunctionReference
implements AnnotatedReference,
FunctionReference {
    private TopLevelFunctionReference() {
    }

    @Nullable
    protected abstract TypeReference getReturnType();

    @Override
    @Nullable
    public TypeReference returnTypeOrNull() {
        return this.getReturnType();
    }

    @NotNull
    public String toString() {
        return this.getFqName() + "()";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TopLevelFunctionReference)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getFqName(), (Object)((TopLevelFunctionReference)other).getFqName());
    }

    public int hashCode() {
        return this.getFqName().hashCode();
    }

    @Override
    public boolean isAnnotatedWith(@NotNull FqName fqName) {
        return AnnotatedReference.DefaultImpls.isAnnotatedWith(this, fqName);
    }

    @Override
    @NotNull
    public String getName() {
        return FunctionReference.DefaultImpls.getName(this);
    }

    @Override
    @NotNull
    public TypeReference returnType() {
        return FunctionReference.DefaultImpls.returnType(this);
    }

    public /* synthetic */ TopLevelFunctionReference(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B!\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010 \u001a\u00020!H\u0016R!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R!\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0010\u001a\u0004\b\u0019\u0010\u000eR\u001d\u0010\u001b\u001a\u0004\u0018\u00010\u001c8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0010\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\""}, d2={"Lcom/squareup/anvil/compiler/internal/reference/TopLevelFunctionReference$Descriptor;", "Lcom/squareup/anvil/compiler/internal/reference/TopLevelFunctionReference;", "Lcom/squareup/anvil/compiler/internal/reference/FunctionReference$Descriptor;", "function", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "module", "Lcom/squareup/anvil/compiler/internal/reference/AnvilModuleDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;Lorg/jetbrains/kotlin/name/FqName;Lcom/squareup/anvil/compiler/internal/reference/AnvilModuleDescriptor;)V", "annotations", "", "Lcom/squareup/anvil/compiler/internal/reference/AnnotationReference$Descriptor;", "getAnnotations", "()Ljava/util/List;", "annotations$delegate", "Lkotlin/Lazy;", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getFunction", "()Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getModule", "()Lcom/squareup/anvil/compiler/internal/reference/AnvilModuleDescriptor;", "parameters", "Lcom/squareup/anvil/compiler/internal/reference/ParameterReference$Descriptor;", "getParameters", "parameters$delegate", "returnType", "Lcom/squareup/anvil/compiler/internal/reference/TypeReference$Descriptor;", "getReturnType", "()Lcom/squareup/anvil/compiler/internal/reference/TypeReference$Descriptor;", "returnType$delegate", "visibility", "Lcom/squareup/anvil/compiler/internal/reference/Visibility;", "compiler-utils"})
    public static final class Descriptor
    extends TopLevelFunctionReference
    implements FunctionReference.Descriptor {
        @NotNull
        private final FunctionDescriptor function;
        @NotNull
        private final FqName fqName;
        @NotNull
        private final AnvilModuleDescriptor module;
        @NotNull
        private final Lazy annotations$delegate;
        @NotNull
        private final Lazy parameters$delegate;
        @NotNull
        private final Lazy returnType$delegate;

        public Descriptor(@NotNull FunctionDescriptor function, @NotNull FqName fqName, @NotNull AnvilModuleDescriptor module) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            super(null);
            this.function = function;
            this.fqName = fqName;
            this.module = module;
            this.annotations$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends AnnotationReference.Descriptor>>(this){
                final /* synthetic */ Descriptor this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<AnnotationReference.Descriptor> invoke() {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = (Iterable)this.this$0.getFunction().getAnnotations();
                    Descriptor descriptor = this.this$0;
                    boolean $i$f$map = false;
                    void var4_4 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(AnnotationReferenceKt.toAnnotationReference((AnnotationDescriptor)it, null, (ModuleDescriptor)descriptor.getModule()));
                    }
                    return (List)destination$iv$iv;
                }
            }));
            this.parameters$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends ParameterReference.Descriptor>>(this){
                final /* synthetic */ Descriptor this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<ParameterReference.Descriptor> invoke() {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    List list = this.this$0.getFunction().getValueParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueParameters(...)");
                    Iterable iterable = list;
                    Descriptor descriptor = this.this$0;
                    boolean $i$f$map = false;
                    void var4_4 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        collection.add(ParameterReferenceKt.toParameterReference((ValueParameterDescriptor)it, descriptor));
                    }
                    return (List)destination$iv$iv;
                }
            }));
            this.returnType$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<TypeReference.Descriptor>(this){
                final /* synthetic */ Descriptor this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final TypeReference.Descriptor invoke() {
                    KotlinType kotlinType = this.this$0.getFunction().getReturnType();
                    return kotlinType != null ? TypeReferenceKt.toTypeReference(kotlinType, null, this.this$0.getModule()) : null;
                }
            }));
        }

        public /* synthetic */ Descriptor(FunctionDescriptor functionDescriptor, FqName fqName, AnvilModuleDescriptor anvilModuleDescriptor, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                fqName = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)functionDescriptor));
            }
            this(functionDescriptor, fqName, anvilModuleDescriptor);
        }

        @Override
        @NotNull
        public FunctionDescriptor getFunction() {
            return this.function;
        }

        @Override
        @NotNull
        public FqName getFqName() {
            return this.fqName;
        }

        @Override
        @NotNull
        public AnvilModuleDescriptor getModule() {
            return this.module;
        }

        @NotNull
        public List<AnnotationReference.Descriptor> getAnnotations() {
            Lazy lazy = this.annotations$delegate;
            return (List)lazy.getValue();
        }

        @NotNull
        public List<ParameterReference.Descriptor> getParameters() {
            Lazy lazy = this.parameters$delegate;
            return (List)lazy.getValue();
        }

        @Override
        @Nullable
        protected TypeReference.Descriptor getReturnType() {
            Lazy lazy = this.returnType$delegate;
            return (TypeReference.Descriptor)lazy.getValue();
        }

        @Override
        @NotNull
        public Visibility visibility() {
            Visibility visibility;
            DescriptorVisibility descriptorVisibility = this.getFunction().getVisibility();
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"getVisibility(...)");
            DescriptorVisibility visibility2 = descriptorVisibility;
            if (Intrinsics.areEqual((Object)visibility2, (Object)DescriptorVisibilities.PUBLIC)) {
                visibility = Visibility.PUBLIC;
            } else if (Intrinsics.areEqual((Object)visibility2, (Object)DescriptorVisibilities.INTERNAL)) {
                visibility = Visibility.INTERNAL;
            } else if (Intrinsics.areEqual((Object)visibility2, (Object)DescriptorVisibilities.PROTECTED)) {
                visibility = Visibility.PROTECTED;
            } else if (Intrinsics.areEqual((Object)visibility2, (Object)DescriptorVisibilities.PRIVATE)) {
                visibility = Visibility.PRIVATE;
            } else {
                throw FunctionReferenceKt.AnvilCompilationExceptionFunctionReference$default(this, "Couldn't get visibility " + visibility2 + " for function " + this.getFqName() + '.', null, 4, null);
            }
            return visibility;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010 \u001a\u00020!H\u0016R!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R!\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0010\u001a\u0004\b\u0019\u0010\u000eR\u001d\u0010\u001b\u001a\u0004\u0018\u00010\u001c8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0010\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\""}, d2={"Lcom/squareup/anvil/compiler/internal/reference/TopLevelFunctionReference$Psi;", "Lcom/squareup/anvil/compiler/internal/reference/TopLevelFunctionReference;", "Lcom/squareup/anvil/compiler/internal/reference/FunctionReference$Psi;", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "module", "Lcom/squareup/anvil/compiler/internal/reference/AnvilModuleDescriptor;", "(Lorg/jetbrains/kotlin/psi/KtFunction;Lorg/jetbrains/kotlin/name/FqName;Lcom/squareup/anvil/compiler/internal/reference/AnvilModuleDescriptor;)V", "annotations", "", "Lcom/squareup/anvil/compiler/internal/reference/AnnotationReference$Psi;", "getAnnotations", "()Ljava/util/List;", "annotations$delegate", "Lkotlin/Lazy;", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getFunction", "()Lorg/jetbrains/kotlin/psi/KtFunction;", "getModule", "()Lcom/squareup/anvil/compiler/internal/reference/AnvilModuleDescriptor;", "parameters", "Lcom/squareup/anvil/compiler/internal/reference/ParameterReference$Psi;", "getParameters", "parameters$delegate", "returnType", "Lcom/squareup/anvil/compiler/internal/reference/TypeReference$Psi;", "getReturnType", "()Lcom/squareup/anvil/compiler/internal/reference/TypeReference$Psi;", "returnType$delegate", "visibility", "Lcom/squareup/anvil/compiler/internal/reference/Visibility;", "compiler-utils"})
    public static final class Psi
    extends TopLevelFunctionReference
    implements FunctionReference.Psi {
        @NotNull
        private final KtFunction function;
        @NotNull
        private final FqName fqName;
        @NotNull
        private final AnvilModuleDescriptor module;
        @NotNull
        private final Lazy annotations$delegate;
        @NotNull
        private final Lazy returnType$delegate;
        @NotNull
        private final Lazy parameters$delegate;

        public Psi(@NotNull KtFunction function, @NotNull FqName fqName, @NotNull AnvilModuleDescriptor module) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            super(null);
            this.function = function;
            this.fqName = fqName;
            this.module = module;
            this.annotations$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends AnnotationReference.Psi>>(this){
                final /* synthetic */ Psi this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<AnnotationReference.Psi> invoke() {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    List list = this.this$0.getFunction().getAnnotationEntries();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAnnotationEntries(...)");
                    Iterable iterable = list;
                    Psi psi = this.this$0;
                    boolean $i$f$map = false;
                    void var4_4 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        collection.add(AnnotationReferenceKt.toAnnotationReference((KtAnnotationEntry)it, null, (ModuleDescriptor)psi.getModule()));
                    }
                    return (List)destination$iv$iv;
                }
            }));
            this.returnType$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<TypeReference.Psi>(this){
                final /* synthetic */ Psi this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final TypeReference.Psi invoke() {
                    KtTypeReference ktTypeReference = this.this$0.getFunction().getTypeReference();
                    return ktTypeReference != null ? TypeReferenceKt.toTypeReference(ktTypeReference, null, this.this$0.getModule()) : null;
                }
            }));
            this.parameters$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends ParameterReference.Psi>>(this){
                final /* synthetic */ Psi this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<ParameterReference.Psi> invoke() {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    List list = this.this$0.getFunction().getValueParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueParameters(...)");
                    Iterable iterable = list;
                    Psi psi = this.this$0;
                    boolean $i$f$map = false;
                    void var4_4 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        KtParameter ktParameter = (KtParameter)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        collection.add(ParameterReferenceKt.toParameterReference((KtParameter)it, psi));
                    }
                    return (List)destination$iv$iv;
                }
            }));
        }

        @Override
        @NotNull
        public KtFunction getFunction() {
            return this.function;
        }

        @Override
        @NotNull
        public FqName getFqName() {
            return this.fqName;
        }

        @Override
        @NotNull
        public AnvilModuleDescriptor getModule() {
            return this.module;
        }

        @NotNull
        public List<AnnotationReference.Psi> getAnnotations() {
            Lazy lazy = this.annotations$delegate;
            return (List)lazy.getValue();
        }

        @Override
        @Nullable
        protected TypeReference.Psi getReturnType() {
            Lazy lazy = this.returnType$delegate;
            return (TypeReference.Psi)lazy.getValue();
        }

        @NotNull
        public List<ParameterReference.Psi> getParameters() {
            Lazy lazy = this.parameters$delegate;
            return (List)lazy.getValue();
        }

        @Override
        @NotNull
        public Visibility visibility() {
            Visibility visibility;
            KtModifierKeywordToken visibility2 = KtPsiUtilKt.visibilityModifierTypeOrDefault((KtModifierListOwner)((KtModifierListOwner)this.getFunction()));
            if (Intrinsics.areEqual((Object)visibility2, (Object)KtTokens.PUBLIC_KEYWORD)) {
                visibility = Visibility.PUBLIC;
            } else if (Intrinsics.areEqual((Object)visibility2, (Object)KtTokens.INTERNAL_KEYWORD)) {
                visibility = Visibility.INTERNAL;
            } else if (Intrinsics.areEqual((Object)visibility2, (Object)KtTokens.PROTECTED_KEYWORD)) {
                visibility = Visibility.PROTECTED;
            } else if (Intrinsics.areEqual((Object)visibility2, (Object)KtTokens.PRIVATE_KEYWORD)) {
                visibility = Visibility.PRIVATE;
            } else {
                throw FunctionReferenceKt.AnvilCompilationExceptionFunctionReference$default(this, "Couldn't get visibility " + visibility2 + " for function " + this.getFqName() + '.', null, 4, null);
            }
            return visibility;
        }
    }
}

