/*
 * Decompiled with CFR 0.152.
 */
package uk.co.flamingpenguin.jewel.cli;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import uk.co.flamingpenguin.jewel.cli.CliSpecificationImpl;
import uk.co.flamingpenguin.jewel.cli.CommandLineInterface;
import uk.co.flamingpenguin.jewel.cli.Option;
import uk.co.flamingpenguin.jewel.cli.OptionMethodSpecification;
import uk.co.flamingpenguin.jewel.cli.OptionSpecificationImpl;
import uk.co.flamingpenguin.jewel.cli.OptionsSpecification;
import uk.co.flamingpenguin.jewel.cli.Unparsed;
import uk.co.flamingpenguin.jewel.cli.UnparsedSpecificationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OptionsSpecificationImpl<O>
implements OptionsSpecification<O> {
    private final Map<String, OptionMethodSpecification> m_optionsShortName = new HashMap<String, OptionMethodSpecification>();
    private final Map<String, OptionMethodSpecification> m_optionsLongName = new TreeMap<String, OptionMethodSpecification>();
    private final Map<Method, OptionMethodSpecification> m_optionsMethod = new HashMap<Method, OptionMethodSpecification>();
    private final Map<Method, OptionMethodSpecification> m_optionalOptionsMethod = new HashMap<Method, OptionMethodSpecification>();
    private UnparsedSpecificationImpl m_unparsed = null;
    private CliSpecificationImpl m_cliSpecification = null;

    public OptionsSpecificationImpl(Class<O> klass) {
        Method[] methods;
        for (Method method : methods = klass.getMethods()) {
            if (Void.class.equals(method.getReturnType())) continue;
            if (method.isAnnotationPresent(Option.class)) {
                OptionSpecificationImpl optionSpecification = new OptionSpecificationImpl(method, klass);
                for (String shortName : optionSpecification.getShortNames()) {
                    this.m_optionsShortName.put(shortName, optionSpecification);
                }
                this.m_optionsLongName.put(optionSpecification.getLongName(), optionSpecification);
                this.m_optionsMethod.put(method, optionSpecification);
                if (!optionSpecification.isOptional()) continue;
                this.m_optionalOptionsMethod.put(optionSpecification.getOptionalityMethod(), optionSpecification);
                continue;
            }
            if (!method.isAnnotationPresent(Unparsed.class)) continue;
            this.m_unparsed = new UnparsedSpecificationImpl(method, klass);
        }
        this.m_cliSpecification = new CliSpecificationImpl(klass.getAnnotation(CommandLineInterface.class), this.m_unparsed, !this.getMandatoryOptions().isEmpty());
    }

    @Override
    public boolean isSpecified(String key) {
        return this.m_optionsShortName.containsKey(key) || this.m_optionsLongName.containsKey(key);
    }

    @Override
    public boolean isSpecified(Method method) {
        return this.m_optionsMethod.containsKey(method) || this.m_optionalOptionsMethod.containsKey(method);
    }

    @Override
    public OptionMethodSpecification getSpecification(String key) {
        if (this.m_optionsLongName.containsKey(key)) {
            return this.m_optionsLongName.get(key);
        }
        return this.m_optionsShortName.get(key);
    }

    @Override
    public OptionMethodSpecification getSpecification(Method method) {
        if (this.m_optionsMethod.containsKey(method)) {
            return this.m_optionsMethod.get(method);
        }
        return this.m_optionalOptionsMethod.get(method);
    }

    @Override
    public List<OptionMethodSpecification> getMandatoryOptions() {
        ArrayList<OptionMethodSpecification> result = new ArrayList<OptionMethodSpecification>();
        for (OptionMethodSpecification specification : this.m_optionsLongName.values()) {
            if (specification.isOptional() || specification.hasDefaultValue()) continue;
            result.add(specification);
        }
        return result;
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder result = new StringBuilder();
        result.append(this.m_cliSpecification).append(lineSeparator);
        String separator = "";
        for (OptionMethodSpecification specification : this.m_optionsLongName.values()) {
            result.append(separator).append("\t").append(specification);
            separator = lineSeparator;
        }
        return result.toString();
    }

    @Override
    public boolean isExistenceChecker(Method method) {
        return this.m_optionalOptionsMethod.containsKey(method);
    }

    @Override
    public Iterator<OptionMethodSpecification> iterator() {
        return new ArrayList<OptionMethodSpecification>(this.m_optionsMethod.values()).iterator();
    }

    @Override
    public UnparsedSpecificationImpl getUnparsedSpecification() {
        return this.m_unparsed;
    }

    @Override
    public boolean hasUnparsedSpecification() {
        return this.m_unparsed != null;
    }
}

