/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.internal;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import net.sourceforge.argparse4j.helper.MessageLocalization;
import net.sourceforge.argparse4j.helper.TextHelper;
import net.sourceforge.argparse4j.helper.TextWidthCounter;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.impl.choice.CollectionArgumentChoice;
import net.sourceforge.argparse4j.impl.type.ReflectArgumentType;
import net.sourceforge.argparse4j.impl.type.StringArgumentType;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentChoice;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.FeatureControl;
import net.sourceforge.argparse4j.inf.MetavarInference;
import net.sourceforge.argparse4j.internal.ArgumentGroupImpl;
import net.sourceforge.argparse4j.internal.ArgumentParserConfigurationImpl;
import net.sourceforge.argparse4j.internal.ArgumentParserImpl;

public final class ArgumentImpl
implements Argument {
    private String name_;
    private String[] flags_;
    private String dest_;
    private ArgumentType<?> type_ = new StringArgumentType();
    private ArgumentAction action_ = Arguments.store();
    private ArgumentChoice choice_;
    private Object const_;
    private Object default_;
    private FeatureControl defaultControl_;
    private FeatureControl helpControl_;
    private boolean required_;
    private String[] metavar_;
    private int minNumArg_ = -1;
    private int maxNumArg_ = -1;
    private String help_ = "";
    private ArgumentParserConfigurationImpl config_;
    private ArgumentGroupImpl argumentGroup_;

    ArgumentImpl(ArgumentParserConfigurationImpl config, String ... nameOrFlags) {
        this(config, (ArgumentGroupImpl)null, nameOrFlags);
    }

    ArgumentImpl(ArgumentParserConfigurationImpl config, ArgumentGroupImpl argumentGroup, String ... nameOrFlags) {
        if (nameOrFlags.length == 0) {
            throw new IllegalArgumentException("no nameOrFlags was specified");
        }
        this.config_ = config;
        this.argumentGroup_ = argumentGroup;
        if (nameOrFlags.length == 1 && !config.prefixPattern_.match(nameOrFlags[0])) {
            if (this.argumentGroup_ != null && this.argumentGroup_.isMutex()) {
                throw new IllegalArgumentException("mutually exclusive arguments must be optional");
            }
            this.name_ = nameOrFlags[0];
            if (!config.noDestConversionForPositionalArgs_) {
                this.dest_ = this.name_.replace('-', '_');
            }
        } else {
            for (String flag : this.flags_ = nameOrFlags) {
                if (config.prefixPattern_.match(flag)) continue;
                throw new IllegalArgumentException(String.format(TextHelper.LOCALE_ROOT, this.localize("invalidOptionStringError"), flag, config.prefixPattern_.getPrefixChars()));
            }
            for (String flag : this.flags_) {
                boolean longFlag = config.prefixPattern_.matchLongFlag(flag);
                if (this.dest_ == null) {
                    this.dest_ = flag;
                    if (!longFlag) continue;
                    break;
                }
                if (!longFlag) continue;
                this.dest_ = flag;
                break;
            }
            this.dest_ = config.prefixPattern_.removePrefix(this.dest_).replace('-', '_');
        }
    }

    @Override
    public String textualName() {
        if (this.name_ == null) {
            return TextHelper.concat(this.flags_, 0, "/");
        }
        return this.name_;
    }

    String formatShortSyntax() {
        if (this.name_ == null) {
            StringBuilder sb = new StringBuilder();
            if (!this.required_) {
                sb.append("[");
            }
            sb.append(this.flags_[0]);
            String mv = this.formatMetavar();
            if (!mv.isEmpty()) {
                sb.append(" ").append(mv);
            }
            if (!this.required_) {
                sb.append("]");
            }
            return sb.toString();
        }
        return this.formatMetavar();
    }

    String formatShortSyntaxNoBracket() {
        if (this.name_ == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.flags_[0]);
            String mv = this.formatMetavar();
            if (!mv.isEmpty()) {
                sb.append(" ").append(mv);
            }
            return sb.toString();
        }
        return this.formatMetavar();
    }

    String[] resolveMetavar() {
        if (this.metavar_ == null) {
            if (this.choice_ == null) {
                String[] metavar;
                if (this.type_ instanceof MetavarInference && (metavar = ((MetavarInference)((Object)this.type_)).inferMetavar()) != null) {
                    return metavar;
                }
                if (this.isNamedArgument()) {
                    return new String[]{this.dest_.toUpperCase()};
                }
                return new String[]{this.dest_};
            }
            return new String[]{this.choice_.textualFormat()};
        }
        return this.metavar_;
    }

    String formatMetavar() {
        StringBuilder sb = new StringBuilder();
        if (this.action_.consumeArgument()) {
            String[] metavar = this.resolveMetavar();
            if (this.minNumArg_ == 0 && this.maxNumArg_ == 1) {
                sb.append("[").append(metavar[0]).append("]");
            } else if (this.minNumArg_ == 0 && this.maxNumArg_ == Integer.MAX_VALUE) {
                sb.append("[").append(metavar[0]).append(" [").append(metavar.length == 1 ? metavar[0] : metavar[1]).append(" ...]]");
            } else if (this.minNumArg_ == 1 && this.maxNumArg_ == Integer.MAX_VALUE) {
                sb.append(metavar[0]).append(" [").append(metavar.length == 1 ? metavar[0] : metavar[1]).append(" ...]");
            } else if (this.minNumArg_ == -1) {
                sb.append(metavar[0]);
            } else if (this.minNumArg_ > 0 && this.minNumArg_ == this.maxNumArg_) {
                int i;
                int max = Math.min(this.minNumArg_, metavar.length);
                for (i = 0; i < max; ++i) {
                    sb.append(metavar[i]).append(" ");
                }
                while (i < this.minNumArg_) {
                    sb.append(metavar[metavar.length - 1]).append(" ");
                    ++i;
                }
                sb.delete(sb.length() - 1, sb.length());
            }
        }
        return sb.toString();
    }

    private String formatHelpTitle() {
        if (this.isNamedArgument()) {
            String mv = this.formatMetavar();
            StringBuilder sb = new StringBuilder();
            if (this.config_.singleMetavar_) {
                for (String flag : this.flags_) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(flag);
                }
                if (!mv.isEmpty()) {
                    sb.append(" ").append(mv);
                }
            } else {
                for (String flag : this.flags_) {
                    sb.append(flag);
                    if (!mv.isEmpty()) {
                        sb.append(" ").append(mv);
                    }
                    sb.append(", ");
                }
                if (sb.length() > 2) {
                    sb.delete(sb.length() - 2, sb.length());
                }
            }
            return sb.toString();
        }
        return this.resolveMetavar()[0];
    }

    public void printHelp(PrintWriter writer, boolean defaultHelp, TextWidthCounter textWidthCounter, int width) {
        String help;
        if (this.helpControl_ == Arguments.SUPPRESS) {
            return;
        }
        if (defaultHelp && this.default_ != null) {
            StringBuilder sb = new StringBuilder(this.help_);
            if (!this.help_.isEmpty()) {
                sb.append(" ");
            }
            sb.append("(default: ").append(this.default_.toString()).append(")");
            help = sb.toString();
        } else {
            help = this.help_;
        }
        TextHelper.printHelp(writer, this.formatHelpTitle(), help, textWidthCounter, width);
    }

    public Object convert(ArgumentParserImpl parser, String value) throws ArgumentParserException {
        Object obj = this.type_.convert(parser, this, value);
        if (this.choice_ != null && !this.choice_.contains(obj)) {
            throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, this.localize("invalidChoiceError"), value, this.choice_.textualFormat()), parser, this);
        }
        return obj;
    }

    @Override
    public ArgumentImpl nargs(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("nargs must be positive integer");
        }
        this.minNumArg_ = this.maxNumArg_ = n;
        return this;
    }

    @Override
    public ArgumentImpl nargs(String n) {
        if (n.equals("*")) {
            this.minNumArg_ = 0;
            this.maxNumArg_ = Integer.MAX_VALUE;
        } else if (n.equals("+")) {
            this.minNumArg_ = 1;
            this.maxNumArg_ = Integer.MAX_VALUE;
        } else if (n.equals("?")) {
            this.minNumArg_ = 0;
            this.maxNumArg_ = 1;
        } else {
            throw new IllegalArgumentException("narg expects positive integer or one of '*', '+' or '?'");
        }
        return this;
    }

    @Override
    public ArgumentImpl setConst(Object value) {
        this.const_ = value;
        return this;
    }

    @Override
    public <E> ArgumentImpl setConst(E ... values2) {
        this.const_ = Arrays.asList(values2);
        return this;
    }

    @Override
    public ArgumentImpl setDefault(Object value) {
        this.default_ = value;
        return this;
    }

    @Override
    public <E> ArgumentImpl setDefault(E ... values2) {
        this.default_ = Arrays.asList(values2);
        return this;
    }

    @Override
    public ArgumentImpl setDefault(FeatureControl ctrl) {
        this.defaultControl_ = ctrl;
        return this;
    }

    private <T> ReflectArgumentType<T> createReflectArgumentType(Class<T> type) {
        return new ReflectArgumentType<T>(type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T> ArgumentImpl type(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                this.type_ = this.createReflectArgumentType(Boolean.class);
                return this;
            } else if (type == Byte.TYPE) {
                this.type_ = this.createReflectArgumentType(Byte.class);
                return this;
            } else if (type == Short.TYPE) {
                this.type_ = this.createReflectArgumentType(Short.class);
                return this;
            } else if (type == Integer.TYPE) {
                this.type_ = this.createReflectArgumentType(Integer.class);
                return this;
            } else if (type == Long.TYPE) {
                this.type_ = this.createReflectArgumentType(Long.class);
                return this;
            } else if (type == Float.TYPE) {
                this.type_ = this.createReflectArgumentType(Float.class);
                return this;
            } else {
                if (type != Double.TYPE) throw new IllegalArgumentException("unexpected primitive type");
                this.type_ = this.createReflectArgumentType(Double.class);
            }
            return this;
        } else {
            this.type_ = this.createReflectArgumentType(type);
        }
        return this;
    }

    @Override
    public <T> ArgumentImpl type(ArgumentType<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        this.type_ = type;
        return this;
    }

    @Override
    public ArgumentImpl required(boolean required) {
        this.required_ = required;
        return this;
    }

    @Override
    public ArgumentImpl action(ArgumentAction action) {
        if (action == null) {
            throw new IllegalArgumentException("action cannot be null");
        }
        this.action_ = action;
        this.action_.onAttach(this);
        return this;
    }

    @Override
    public ArgumentImpl choices(ArgumentChoice choice) {
        if (choice == null) {
            throw new IllegalArgumentException("choice cannot be null");
        }
        this.choice_ = choice;
        return this;
    }

    @Override
    public <E> ArgumentImpl choices(Collection<E> values2) {
        if (values2 == null) {
            throw new IllegalArgumentException("choice cannot be null");
        }
        this.choice_ = new CollectionArgumentChoice<E>(values2);
        return this;
    }

    @Override
    public <E> ArgumentImpl choices(E ... values2) {
        if (values2 == null) {
            throw new IllegalArgumentException("choice cannot be null");
        }
        this.choice_ = new CollectionArgumentChoice<E>(values2);
        return this;
    }

    @Override
    public ArgumentImpl dest(String dest) {
        if (dest == null) {
            throw new IllegalArgumentException("dest cannot be null");
        }
        this.dest_ = dest;
        return this;
    }

    @Override
    public ArgumentImpl metavar(String ... metavar) {
        if (metavar.length == 0) {
            throw new IllegalArgumentException("No metavar specified");
        }
        for (String m3 : metavar) {
            if (m3 != null) continue;
            throw new IllegalArgumentException("metavar cannot be null");
        }
        this.metavar_ = metavar;
        return this;
    }

    @Override
    public ArgumentImpl help(String help) {
        this.help_ = TextHelper.nonNull(help);
        return this;
    }

    @Override
    public ArgumentImpl help(FeatureControl ctrl) {
        this.helpControl_ = ctrl;
        return this;
    }

    boolean isNamedArgument() {
        return this.name_ == null;
    }

    public void run(ArgumentParserImpl parser, Map<String, Object> res, String flag, Object value) throws ArgumentParserException {
        this.action_.run(parser, this, res, flag, value);
    }

    @Override
    public String getDest() {
        return this.dest_;
    }

    @Override
    public Object getConst() {
        return this.const_;
    }

    @Override
    public Object getDefault() {
        if (!this.isNamedArgument() && this.default_ == null && this.maxNumArg_ > 1) {
            return new ArrayList();
        }
        return this.default_;
    }

    @Override
    public FeatureControl getDefaultControl() {
        return this.defaultControl_;
    }

    @Override
    public FeatureControl getHelpControl() {
        return this.helpControl_;
    }

    public String getName() {
        return this.name_;
    }

    public boolean isRequired() {
        return this.required_;
    }

    int getMinNumArg() {
        return this.minNumArg_;
    }

    int getMaxNumArg() {
        return this.maxNumArg_;
    }

    public String[] getMetavar() {
        return this.metavar_;
    }

    ArgumentGroupImpl getArgumentGroup() {
        return this.argumentGroup_;
    }

    public ArgumentAction getAction() {
        return this.action_;
    }

    public String getHelp() {
        return this.help_;
    }

    String[] getFlags() {
        return this.flags_;
    }

    private String localize(String messageKey) {
        return MessageLocalization.localize(this.config_.getResourceBundle(), messageKey);
    }
}

